/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessages;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={ExternalTransformRegistrar.class})
public final class ExternalRead
implements ExternalTransformRegistrar {
    public static final @UnknownKeyFor @NonNull @Initialized String URN = "beam:transform:org.apache.beam:pubsub_read:v1";

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExternalTransformBuilder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> knownBuilders() {
        return ImmutableMap.of((Object)URN, ReadBuilder.class);
    }

    public static class ReadBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<byte[]>> {
        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> buildExternal(@UnknownKeyFor @NonNull @Initialized Configuration config) {
            PubsubIO.Read.Builder<Object> readBuilder;
            if (config.needsAttributes) {
                readBuilder = PubsubIO.Read.newBuilder(new PubsubMessages.ParsePayloadAsPubsubMessageProto());
                readBuilder.setNeedsAttributes(true);
            } else {
                readBuilder = PubsubIO.Read.newBuilder(PubsubMessage::getPayload);
            }
            readBuilder.setCoder((Coder<Object>)ByteArrayCoder.of());
            if (config.topic != null) {
                ValueProvider.StaticValueProvider topic = ValueProvider.StaticValueProvider.of((Object)config.topic);
                readBuilder.setTopicProvider((ValueProvider<PubsubIO.PubsubTopic>)ValueProvider.NestedValueProvider.of((ValueProvider)topic, PubsubIO.PubsubTopic::fromPath));
            }
            if (config.subscription != null) {
                ValueProvider.StaticValueProvider subscription = ValueProvider.StaticValueProvider.of((Object)config.subscription);
                readBuilder.setSubscriptionProvider((ValueProvider<PubsubIO.PubsubSubscription>)ValueProvider.NestedValueProvider.of((ValueProvider)subscription, PubsubIO.PubsubSubscription::fromPath));
            }
            if (config.idAttribute != null) {
                readBuilder.setIdAttribute(config.idAttribute);
            }
            if (config.timestampAttribute != null) {
                readBuilder.setTimestampAttribute(config.timestampAttribute);
            }
            return readBuilder.build();
        }
    }

    public static class Configuration {
        private @Nullable @UnknownKeyFor @Initialized String topic;
        private @Nullable @UnknownKeyFor @Initialized String subscription;
        private @Nullable @UnknownKeyFor @Initialized String idAttribute;
        private @Nullable @UnknownKeyFor @Initialized String timestampAttribute;
        private @UnknownKeyFor @NonNull @Initialized boolean needsAttributes;

        public void setTopic(@Nullable @UnknownKeyFor @Initialized String topic) {
            this.topic = topic;
        }

        public void setSubscription(@Nullable @UnknownKeyFor @Initialized String subscription) {
            this.subscription = subscription;
        }

        public void setIdLabel(@Nullable @UnknownKeyFor @Initialized String idAttribute) {
            this.idAttribute = idAttribute;
        }

        public void setTimestampAttribute(@Nullable @UnknownKeyFor @Initialized String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
        }

        public void setWithAttributes(@UnknownKeyFor @NonNull @Initialized Boolean needsAttributes) {
            this.needsAttributes = needsAttributes;
        }
    }
}

