/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.testing.AutoValue_BigqueryMatcher_TableAndQuery;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Experimental
public class BigqueryMatcher
extends TypeSafeMatcher<TableAndQuery>
implements SerializableMatcher<TableAndQuery> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigqueryMatcher.class);
    private static final @UnknownKeyFor @NonNull @Initialized int TOTAL_FORMATTED_ROWS = 20;
    private final @UnknownKeyFor @NonNull @Initialized String expectedChecksum;
    private @UnknownKeyFor @NonNull @Initialized String actualChecksum;
    private transient @UnknownKeyFor @NonNull @Initialized QueryResponse response;
    private @UnknownKeyFor @NonNull @Initialized BigqueryClient bigqueryClient;

    private BigqueryMatcher(@UnknownKeyFor @NonNull @Initialized String expectedChecksum) {
        this.validateArgument("expectedChecksum", expectedChecksum);
        this.expectedChecksum = expectedChecksum;
    }

    public static @UnknownKeyFor @NonNull @Initialized BigqueryMatcher queryResultHasChecksum(@UnknownKeyFor @NonNull @Initialized String checksum) {
        return new BigqueryMatcher(checksum);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableAndQuery createQuery(@UnknownKeyFor @NonNull @Initialized String applicationName, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String query) {
        return TableAndQuery.create(applicationName, projectId, query, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableAndQuery createQueryUsingStandardSql(@UnknownKeyFor @NonNull @Initialized String applicationName, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String query) {
        return TableAndQuery.create(applicationName, projectId, query, true);
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(@UnknownKeyFor @NonNull @Initialized TableAndQuery tableAndQuery) {
        this.bigqueryClient = BigqueryClient.getClient(tableAndQuery.getApplicationName());
        LOG.info("Verifying Bigquery data");
        LOG.debug("Executing query: {}", (Object)tableAndQuery.getQuery());
        try {
            this.response = tableAndQuery.getUsingStandardSql().booleanValue() ? this.bigqueryClient.queryWithRetriesUsingStandardSql(tableAndQuery.getQuery(), tableAndQuery.getProjectId()) : this.bigqueryClient.queryWithRetries(tableAndQuery.getQuery(), tableAndQuery.getProjectId());
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Failed to fetch BigQuery data.", e);
        }
        if (!this.response.getJobComplete().booleanValue()) {
            return false;
        }
        this.actualChecksum = this.generateHash(this.response.getRows());
        LOG.debug("Generated a SHA1 checksum based on queried data: {}", (Object)this.actualChecksum);
        return this.expectedChecksum.equals(this.actualChecksum);
    }

    private void validateArgument(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Expected valid %s, but was %s", (Object)name, (Object)value);
    }

    private @UnknownKeyFor @NonNull @Initialized String generateHash(@Nonnull @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows) {
        ArrayList rowHashes = Lists.newArrayList();
        for (TableRow row : rows) {
            ArrayList cellsInOneRow = Lists.newArrayList();
            for (TableCell cell : row.getF()) {
                cellsInOneRow.add(Objects.toString(cell.getV()));
                Collections.sort(cellsInOneRow);
            }
            rowHashes.add(Hashing.sha1().hashString((CharSequence)((Object)cellsInOneRow).toString(), StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered((Iterable)rowHashes).toString();
    }

    public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(@UnknownKeyFor @NonNull @Initialized TableAndQuery tableAndQuery, @UnknownKeyFor @NonNull @Initialized Description description) {
        String info = this.response.getJobComplete() == false ? String.format("The query job hasn't completed. Got response: %s", this.response) : String.format("was (%s).%n\tTotal number of rows are: %d.%n\tQueried data details:%s", this.actualChecksum, this.response.getTotalRows(), this.formatRows(20));
        description.appendText(info);
    }

    private @UnknownKeyFor @NonNull @Initialized String formatRows(@UnknownKeyFor @NonNull @Initialized int totalNumRows) {
        StringBuilder samples = new StringBuilder();
        List rows = this.response.getRows();
        for (int i = 0; i < totalNumRows && i < rows.size(); ++i) {
            samples.append(String.format("%n\t\t", new Object[0]));
            for (TableCell field : ((TableRow)rows.get(i)).getF()) {
                samples.append(String.format("%-10s", field.getV()));
            }
        }
        if (rows.size() > totalNumRows) {
            samples.append(String.format("%n\t\t...", new Object[0]));
        }
        return samples.toString();
    }

    @AutoValue
    public static abstract class TableAndQuery {
        public static @UnknownKeyFor @NonNull @Initialized TableAndQuery create(@UnknownKeyFor @NonNull @Initialized String applicationName, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized Boolean usingStandardSql) {
            return new AutoValue_BigqueryMatcher_TableAndQuery(applicationName, projectId, query, usingStandardSql);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getApplicationName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getProjectId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getQuery();

        public abstract @UnknownKeyFor @NonNull @Initialized Boolean getUsingStandardSql();
    }
}

