/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class MutationCellCounter {
    private MutationCellCounter() {
    }

    public static @UnknownKeyFor @NonNull @Initialized long countOf(@UnknownKeyFor @NonNull @Initialized SpannerSchema spannerSchema, @UnknownKeyFor @NonNull @Initialized MutationGroup mutationGroup) {
        long mutatedCells = 0L;
        for (Mutation mutation : mutationGroup) {
            if (mutation.getOperation() == Mutation.Op.DELETE) {
                if (!MutationUtils.isPointDelete(mutation)) continue;
                KeySet keySet = mutation.getKeySet();
                long rows = Iterables.size((Iterable)keySet.getKeys());
                mutatedCells += rows * spannerSchema.getCellsMutatedPerRow(mutation.getTable());
                continue;
            }
            for (String column : mutation.getColumns()) {
                mutatedCells += spannerSchema.getCellsMutatedPerColumn(mutation.getTable(), column);
            }
        }
        return mutatedCells;
    }
}

