/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.AddTimestampAttribute;
import org.apache.beam.sdk.io.gcp.pubsub.NestedRowToMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidSchemaException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializers;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={SchemaIOProvider.class})
public class PubsubSchemaIOProvider
implements SchemaIOProvider {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType ATTRIBUTE_MAP_FIELD_TYPE = Schema.FieldType.map((Schema.FieldType)Schema.FieldType.STRING.withNullable(false), (Schema.FieldType)Schema.FieldType.STRING);
    public static final @UnknownKeyFor @NonNull @Initialized Schema ATTRIBUTE_ARRAY_ENTRY_SCHEMA = Schema.builder().addStringField("key").addStringField("value").build();
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType ATTRIBUTE_ARRAY_FIELD_TYPE = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)ATTRIBUTE_ARRAY_ENTRY_SCHEMA));

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "pubsub";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addNullableField("timestampAttributeKey", Schema.FieldType.STRING).addNullableField("deadLetterQueue", Schema.FieldType.STRING).addNullableField("format", Schema.FieldType.STRING).addNullableField("thriftClass", Schema.FieldType.STRING).addNullableField("thriftProtocolFactoryClass", Schema.FieldType.STRING).addNullableField("protoClass", Schema.FieldType.STRING).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PubsubSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        this.validateConfigurationSchema(configuration);
        this.validateDlq((String)configuration.getValue("deadLetterQueue"));
        this.validateDataSchema(dataSchema);
        return new PubsubSchemaIO(location, configuration, dataSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    private void validateDataSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (schema == null) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must not be null");
        }
        if (!PubsubSchemaIO.fieldPresent(schema, "event_timestamp", Schema.FieldType.DATETIME)) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must include at least 'event_timestamp' field of type 'TIMESTAMP'");
        }
    }

    private void validateDlq(@UnknownKeyFor @NonNull @Initialized String deadLetterQueue) {
        if (deadLetterQueue != null && deadLetterQueue.isEmpty()) {
            throw new InvalidConfigurationException("Dead letter queue topic name is not specified");
        }
    }

    private void validateConfigurationSchema(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        if (!configuration.getSchema().equals((Object)this.configurationSchema())) {
            throw new InvalidConfigurationException("Configuration schema provided does not match expected");
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema stripFromTimestampField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        List<Schema.Field> selectedFields = schema.getFields().stream().filter(field -> !"event_timestamp".equals(field.getName())).collect(Collectors.toList());
        return Schema.of((Schema.Field[])selectedFields.toArray(new Schema.Field[0]));
    }

    @AutoValue
    static abstract class Config
    implements Serializable {
        Config() {
        }

        abstract @Nullable @UnknownKeyFor @Initialized String getTimestampAttributeKey();

        abstract @Nullable @UnknownKeyFor @Initialized String getDeadLetterQueue();

        abstract @Nullable @UnknownKeyFor @Initialized String getFormat();

        abstract @Nullable @UnknownKeyFor @Initialized String getThriftClass();

        abstract @Nullable @UnknownKeyFor @Initialized String getThriftProtocolFactoryClass();

        abstract @Nullable @UnknownKeyFor @Initialized String getProtoClass();

        @UnknownKeyFor @NonNull @Initialized boolean useDeadLetterQueue() {
            return this.getDeadLetterQueue() != null;
        }

        @UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute() {
            return this.getTimestampAttributeKey() != null;
        }

        @UnknownKeyFor @NonNull @Initialized PayloadSerializer serializer(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            String format = this.getFormat() == null ? "json" : this.getFormat();
            ImmutableMap.Builder params = ImmutableMap.builder();
            if (this.getThriftClass() != null) {
                params.put((Object)"thriftClass", (Object)this.getThriftClass());
            }
            if (this.getThriftProtocolFactoryClass() != null) {
                params.put((Object)"thriftProtocolFactoryClass", (Object)this.getThriftProtocolFactoryClass());
            }
            if (this.getProtoClass() != null) {
                params.put((Object)"protoClass", (Object)this.getProtoClass());
            }
            return PayloadSerializers.getSerializer((String)format, (Schema)schema, (Map)params.build());
        }
    }

    private static class PubsubSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Schema dataSchema;
        protected final @UnknownKeyFor @NonNull @Initialized String location;
        protected final @UnknownKeyFor @NonNull @Initialized boolean useFlatSchema;
        protected final @UnknownKeyFor @NonNull @Initialized Config config;

        private PubsubSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
            this.useFlatSchema = !this.shouldUseNestedSchema(dataSchema);
            this.config = (Config)new AutoValueSchema().fromRowFunction(TypeDescriptor.of(Config.class)).apply((Object)config);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return this.dataSchema;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean needsSerializer() {
            return this.useFlatSchema || !PubsubSchemaIO.fieldPresent(this.schema(), "payload", Schema.FieldType.BYTES);
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
                    PubsubMessageToRow.Builder builder = PubsubMessageToRow.builder().messageSchema(dataSchema).useDlq(config.useDeadLetterQueue()).useFlatSchema(useFlatSchema);
                    if (this.needsSerializer()) {
                        builder.serializerProvider(config::serializer);
                    }
                    PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)begin.apply("ReadFromPubsub", (PTransform)this.readMessagesWithAttributes())).apply("PubsubMessageToRow", (PTransform)builder.build());
                    rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG).setRowSchema(dataSchema);
                    if (config.useDeadLetterQueue()) {
                        rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply((PTransform)this.writeMessagesToDlq());
                    }
                    return rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> buildWriter() {
            final @Nullable PayloadSerializer serializer = this.needsSerializer() ? this.config.serializer(PubsubSchemaIOProvider.stripFromTimestampField(this.dataSchema)) : null;
            return new PTransform<PCollection<Row>, POutput>(){

                public @UnknownKeyFor @NonNull @Initialized POutput expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    PCollection filtered = (PCollection)input.apply((PTransform)new AddTimestampAttribute(config.useTimestampAttribute()));
                    PCollection transformed = useFlatSchema ? (PCollection)filtered.apply("Transform Flat Schema", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via((SerializableFunction & Serializable)row -> new PubsubMessage(serializer.serialize(row), (Map<String, String>)ImmutableMap.of()))) : (PCollection)filtered.apply("Transform Nested Schema", (PTransform)MapElements.via((SimpleFunction)new NestedRowToMessage(serializer, filtered.getSchema())));
                    return transformed.apply((PTransform)this.createPubsubMessageWrite());
                }
            };
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessagesWithAttributes() {
            PubsubIO.Read<PubsubMessage> read = PubsubIO.readMessagesWithAttributes().fromTopic(this.location);
            return this.config.useTimestampAttribute() ? read.withTimestampAttribute(this.config.getTimestampAttributeKey()) : read;
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> createPubsubMessageWrite() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.location);
            if (this.config.useTimestampAttribute()) {
                write = write.withTimestampAttribute(this.config.getTimestampAttributeKey());
            }
            return write;
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> writeMessagesToDlq() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.config.getDeadLetterQueue());
            return this.config.useTimestampAttribute() ? write.withTimestampAttribute(this.config.getTimestampAttributeKey()) : write;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean hasValidAttributesField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return PubsubSchemaIO.fieldPresent(schema, "attributes", ATTRIBUTE_MAP_FIELD_TYPE) || PubsubSchemaIO.fieldPresent(schema, "attributes", ATTRIBUTE_ARRAY_FIELD_TYPE);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean hasValidPayloadField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (!schema.hasField("payload")) {
                return false;
            }
            if (PubsubSchemaIO.fieldPresent(schema, "payload", Schema.FieldType.BYTES)) {
                return true;
            }
            return schema.getField("payload").getType().getTypeName().equals((Object)Schema.TypeName.ROW);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean shouldUseNestedSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return this.hasValidPayloadField(schema) && this.hasValidAttributesField(schema);
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean fieldPresent(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType expectedType) {
            return schema.hasField(field) && expectedType.equivalent(schema.getField(field).getType(), Schema.EquivalenceNullablePolicy.IGNORE);
        }
    }
}

