/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.reconciler;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class PartitionReconciler {
    @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ByteString>> partitionsToReconcile = new HashMap();
    @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized ByteString> newPartitions = new HashMap();
    @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    private static final @UnknownKeyFor @NonNull @Initialized long MISSING_PARTITION_DELAY_MILLI = 300000L;

    public PartitionReconciler(@UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao) {
        this.metadataTableDao = metadataTableDao;
    }

    public void addMissingPartitions(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> missingPartitions) {
        HashMap<Range.ByteStringRange, Long> alreadyMissingPartitions = this.metadataTableDao.readDetectNewPartitionMissingPartitions();
        HashMap<Range.ByteStringRange, Long> missingPartitionDuration = new HashMap<Range.ByteStringRange, Long>();
        long now = Instant.now().getMillis();
        for (Range.ByteStringRange missingPartition : missingPartitions) {
            if (!ByteStringRangeHelper.isValidPartition(missingPartition)) continue;
            if (alreadyMissingPartitions.containsKey(missingPartition)) {
                missingPartitionDuration.put(missingPartition, alreadyMissingPartitions.get(missingPartition));
                if (alreadyMissingPartitions.get(missingPartition) + 300000L >= now) continue;
                this.partitionsToReconcile.put(missingPartition, new HashSet());
                continue;
            }
            missingPartitionDuration.put(missingPartition, now);
        }
        this.metadataTableDao.writeDetectNewPartitionMissingPartitions(missingPartitionDuration);
    }

    public void addNewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized ByteString rowKey) {
        this.newPartitions.put(partition, rowKey);
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ByteString> findOverlappingNewPartitions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partitionToReconcile) {
        HashSet<ByteString> overlappingRowKey = new HashSet<ByteString>();
        for (Range.ByteStringRange newPartition : this.newPartitions.keySet()) {
            if (!ByteStringRangeHelper.doPartitionsOverlap(newPartition, partitionToReconcile)) continue;
            overlappingRowKey.add(this.newPartitions.get(newPartition));
        }
        return overlappingRowKey;
    }

    public @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ByteString>> getPartitionsToReconcile() {
        this.partitionsToReconcile.replaceAll((r, v) -> this.findOverlappingNewPartitions((Range.ByteStringRange)r));
        return this.partitionsToReconcile;
    }
}

