/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.encoder;

import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class MetadataTableEncoder {
    public static @Nullable @UnknownKeyFor @Initialized Instant parseWatermarkFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("watermark", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return Instant.ofEpochMilli((long)Longs.fromByteArray((byte[])((RowCell)cells.get(0)).getValue().toByteArray()));
    }

    public static @Nullable @UnknownKeyFor @Initialized String getTokenFromRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        List cells = row.getCells("continuation_token", "latest");
        if (cells.size() == 0) {
            return null;
        }
        return ((RowCell)cells.get(0)).getValue().toStringUtf8();
    }
}

