/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn;

import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.DetectNewPartitionsAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.action.GenerateInitialPartitionsAction;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@DoFn.UnboundedPerElement
@Internal
public class DetectNewPartitionsDoFn
extends DoFn<Instant, PartitionRecord> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 8052524268978107367L;
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory;
    private @UnknownKeyFor @NonNull @Initialized DetectNewPartitionsAction detectNewPartitionsAction;

    public DetectNewPartitionsDoFn(@UnknownKeyFor @NonNull @Initialized ActionFactory actionFactory, @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.actionFactory = actionFactory;
        this.daoFactory = daoFactory;
        this.metrics = metrics;
    }

    @DoFn.GetInitialWatermarkEstimatorState
    public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Instant startTime) {
        return startTime;
    }

    @DoFn.NewWatermarkEstimator
    public @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
        return new WatermarkEstimators.Manual(watermarkEstimatorState);
    }

    @DoFn.GetInitialRestriction
    public @UnknownKeyFor @NonNull @Initialized OffsetRange initialRestriction() {
        return new OffsetRange(0L, Long.MAX_VALUE);
    }

    @DoFn.NewTracker
    public @UnknownKeyFor @NonNull @Initialized OffsetRangeTracker restrictionTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction) {
        return new OffsetRangeTracker(restriction);
    }

    @DoFn.GetSize
    public @UnknownKeyFor @NonNull @Initialized double getSize() {
        return 0.0;
    }

    @DoFn.Setup
    public void setup() throws @UnknownKeyFor @NonNull @Initialized IOException {
        MetadataTableDao metadataTableDao = this.daoFactory.getMetadataTableDao();
        ChangeStreamDao changeStreamDao = this.daoFactory.getChangeStreamDao();
        GenerateInitialPartitionsAction generateInitialPartitionsAction = this.actionFactory.generateInitialPartitionsAction(this.metrics, changeStreamDao);
        this.detectNewPartitionsAction = this.actionFactory.detectNewPartitionsAction(this.metrics, metadataTableDao, generateInitialPartitionsAction);
    }

    @DoFn.ProcessElement
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionRecord> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.detectNewPartitionsAction.run(tracker, receiver, watermarkEstimator, bundleFinalizer, startTime);
    }
}

