/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class ByteStringRangeHelper {
    private static @UnknownKeyFor @NonNull @Initialized int compareStartKey(@UnknownKeyFor @NonNull @Initialized ByteString s1, @UnknownKeyFor @NonNull @Initialized ByteString s2) {
        return ByteString.unsignedLexicographicalComparator().compare(s1, s2);
    }

    private static @UnknownKeyFor @NonNull @Initialized int compareEndKey(@UnknownKeyFor @NonNull @Initialized ByteString e1, @UnknownKeyFor @NonNull @Initialized ByteString e2) {
        if (e1.isEmpty() && !e2.isEmpty()) {
            return 1;
        }
        if (e2.isEmpty() && !e1.isEmpty()) {
            return -1;
        }
        return ByteString.unsignedLexicographicalComparator().compare(e1, e2);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isSuperset(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> parentPartitions, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange childPartition) {
        if (parentPartitions.isEmpty()) {
            return false;
        }
        parentPartitions.sort(new PartitionComparator());
        ByteString parentStartKey = (ByteString)parentPartitions.get(0).getStart();
        ByteString parentEndKey = (ByteString)parentPartitions.get(parentPartitions.size() - 1).getEnd();
        return !ByteStringRangeHelper.childStartsBeforeParent(parentStartKey, (ByteString)childPartition.getStart()) && !ByteStringRangeHelper.childEndsAfterParent(parentEndKey, (ByteString)childPartition.getEnd()) && !ByteStringRangeHelper.gapsInParentPartitions(parentPartitions);
    }

    public static @UnknownKeyFor @NonNull @Initialized String partitionsToString(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions) {
        return partitions.stream().map(ByteStringRangeHelper::formatByteStringRange).collect(Collectors.joining(", ", "{", "}"));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> getMissingAndOverlappingPartitionsFromKeySpace(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> partitions) {
        if (partitions.isEmpty()) {
            return Collections.singletonList(Range.ByteStringRange.create((String)"", (String)""));
        }
        ArrayList<Range.ByteStringRange> missingPartitions = new ArrayList<Range.ByteStringRange>();
        partitions.sort(new PartitionComparator());
        ByteString prevEnd = ByteString.EMPTY;
        for (Range.ByteStringRange partition : partitions) {
            if (!((ByteString)partition.getStart()).equals((Object)prevEnd)) {
                Range.ByteStringRange missingPartition = Range.ByteStringRange.create((ByteString)prevEnd, (ByteString)((ByteString)partition.getStart()));
                missingPartitions.add(missingPartition);
            }
            prevEnd = (ByteString)partition.getEnd();
        }
        if (!prevEnd.equals((Object)ByteString.EMPTY)) {
            Range.ByteStringRange missingPartition = Range.ByteStringRange.create((ByteString)prevEnd, (ByteString)ByteString.EMPTY);
            missingPartitions.add(missingPartition);
        }
        return missingPartitions;
    }

    public static @UnknownKeyFor @NonNull @Initialized String formatByteStringRange(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return "['" + TextFormat.escapeBytes((ByteString)((ByteString)partition.getStart())) + "','" + TextFormat.escapeBytes((ByteString)((ByteString)partition.getEnd())) + "')";
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean childStartsBeforeParent(@UnknownKeyFor @NonNull @Initialized ByteString parentStartKey, @UnknownKeyFor @NonNull @Initialized ByteString childStartKey) {
        return ByteStringRangeHelper.compareStartKey(parentStartKey, childStartKey) > 0;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean childEndsAfterParent(@UnknownKeyFor @NonNull @Initialized ByteString parentEndKey, @UnknownKeyFor @NonNull @Initialized ByteString childEndKey) {
        return ByteStringRangeHelper.compareEndKey(parentEndKey, childEndKey) < 0;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean gapsInParentPartitions(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> sortedParentPartitions) {
        for (int i = 1; i < sortedParentPartitions.size(); ++i) {
            ByteString prevEndKey = (ByteString)sortedParentPartitions.get(i - 1).getEnd();
            if (ByteString.unsignedLexicographicalComparator().compare((ByteString)sortedParentPartitions.get(i).getStart(), prevEndKey) <= 0 || prevEndKey.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean doPartitionsOverlap(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange first, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange second) {
        if (ByteString.unsignedLexicographicalComparator().compare((ByteString)second.getStart(), (ByteString)first.getEnd()) >= 0 && !((ByteString)first.getEnd()).isEmpty()) {
            return false;
        }
        return ByteString.unsignedLexicographicalComparator().compare((ByteString)first.getStart(), (ByteString)second.getEnd()) < 0 || ((ByteString)second.getEnd()).isEmpty();
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isValidPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition) {
        return ByteString.unsignedLexicographicalComparator().compare((ByteString)partition.getStart(), (ByteString)partition.getEnd()) < 0 || ((ByteString)partition.getEnd()).isEmpty();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange getIntersectingPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange p1, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange p2) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        if (!ByteStringRangeHelper.doPartitionsOverlap(p1, p2)) {
            throw new IllegalArgumentException(String.format("The partitions %s and %s have no overlap", ByteStringRangeHelper.formatByteStringRange(p1), ByteStringRangeHelper.formatByteStringRange(p2)));
        }
        ByteString start = (ByteString)p1.getStart();
        ByteString end = (ByteString)p1.getEnd();
        if (ByteStringRangeHelper.compareStartKey(start, (ByteString)p2.getStart()) < 0) {
            start = (ByteString)p2.getStart();
        }
        if (ByteStringRangeHelper.compareEndKey(end, (ByteString)p2.getEnd()) > 0) {
            end = (ByteString)p2.getEnd();
        }
        return Range.ByteStringRange.create((ByteString)start, (ByteString)end);
    }

    @VisibleForTesting
    static class PartitionComparator
    implements Comparator<Range.ByteStringRange> {
        PartitionComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange first, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange second) {
            int compareStart = ByteStringRangeHelper.compareStartKey((ByteString)first.getStart(), (ByteString)second.getStart());
            if (compareStart != 0) {
                return compareStart;
            }
            return ByteStringRangeHelper.compareEndKey((ByteString)first.getEnd(), (ByteString)second.getEnd());
        }
    }
}

