/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class ChildPartitionsRecord
implements ChangeStreamRecord {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 5442772555232576887L;
    @AvroEncode(using=TimestampEncoding.class)
    private @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp;
    private @UnknownKeyFor @NonNull @Initialized String recordSequence;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChildPartition> childPartitions;
    @org.apache.avro.reflect.Nullable
    private @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata;

    private ChildPartitionsRecord() {
    }

    public ChildPartitionsRecord(@UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized String recordSequence, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChildPartition> childPartitions, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecordMetadata metadata) {
        this.startTimestamp = startTimestamp;
        this.recordSequence = recordSequence;
        this.childPartitions = childPartitions;
        this.metadata = metadata;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timestamp getRecordTimestamp() {
        return this.getStartTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRecordSequence() {
        return this.recordSequence;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChildPartition> getChildPartitions() {
        return this.childPartitions;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildPartitionsRecord)) {
            return false;
        }
        ChildPartitionsRecord that = (ChildPartitionsRecord)o;
        return Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.recordSequence, that.recordSequence) && Objects.equals(this.childPartitions, that.childPartitions);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.startTimestamp, this.recordSequence, this.childPartitions);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ChildPartitionsRecord{startTimestamp=" + this.startTimestamp + ", recordSequence='" + this.recordSequence + '\'' + ", childPartitions=" + this.childPartitions + ", metadata=" + this.metadata + '}';
    }
}

