/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaTransformMessageToRowFactory;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaTransformReadConfiguration;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializers;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public class PubsubSchemaTransformReadProvider
extends TypedSchemaTransformProvider<PubsubSchemaTransformReadConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String API = "pubsub";
    static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "OUTPUT";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubSchemaTransformReadConfiguration> configurationClass() {
        return PubsubSchemaTransformReadConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized PubsubSchemaTransformReadConfiguration configuration) {
        PubsubMessageToRow toRowTransform = PubsubSchemaTransformMessageToRowFactory.from(configuration).buildMessageToRow();
        return new PubsubReadSchemaTransform(configuration, toRowTransform);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("%s:read", API);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    static class PubsubReadSchemaTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple>
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized PubsubSchemaTransformReadConfiguration configuration;
        private final @UnknownKeyFor @NonNull @Initialized PubsubMessageToRow pubsubMessageToRow;
        private @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory clientFactory;
        private @UnknownKeyFor @NonNull @Initialized Clock clock;

        private PubsubReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized PubsubSchemaTransformReadConfiguration configuration, @UnknownKeyFor @NonNull @Initialized PubsubMessageToRow pubsubMessageToRow) {
            this.configuration = configuration;
            this.pubsubMessageToRow = pubsubMessageToRow;
        }

        void setClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory value) {
            this.clientFactory = value;
        }

        void setClock(@UnknownKeyFor @NonNull @Initialized Clock clock) {
            this.clock = clock;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return this;
        }

        public void validate(@Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
            if (this.configuration.getSubscription() == null && this.configuration.getTopic() == null) {
                throw new IllegalArgumentException(String.format("%s needs to set either the topic or the subscription", PubsubSchemaTransformReadConfiguration.class));
            }
            if (this.configuration.getSubscription() != null && this.configuration.getTopic() != null) {
                throw new IllegalArgumentException(String.format("%s should not set both the topic or the subscription", PubsubSchemaTransformReadConfiguration.class));
            }
            try {
                PayloadSerializers.getSerializer((String)this.configuration.getFormat(), (Schema)this.configuration.getDataSchema(), new HashMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid %s, no serializer provider exists for format `%s`", PubsubSchemaTransformReadConfiguration.class, this.configuration.getFormat()));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (!input.getAll().isEmpty()) {
                throw new IllegalArgumentException(String.format("%s %s input is expected to be empty", input.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName()));
            }
            PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)input.getPipeline().apply("ReadFromPubsub", this.buildPubsubRead())).apply("PubsubMessageToRow", (PTransform)this.pubsubMessageToRow);
            this.writeToDeadLetterQueue(rowsWithDlq);
            return PCollectionRowTuple.of((String)PubsubSchemaTransformReadProvider.OUTPUT_TAG, (PCollection)rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG));
        }

        private void writeToDeadLetterQueue(@UnknownKeyFor @NonNull @Initialized PCollectionTuple rowsWithDlq) {
            PubsubIO.Write<PubsubMessage> deadLetterQueue = this.buildDeadLetterQueueWrite();
            if (deadLetterQueue == null) {
                return;
            }
            rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply("WriteToDeadLetterQueue", deadLetterQueue);
        }

        @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> buildDeadLetterQueueWrite() {
            if (this.configuration.getDeadLetterQueue() == null) {
                return null;
            }
            PubsubIO.Write<PubsubMessage> writeDlq = PubsubIO.writeMessages().to(this.configuration.getDeadLetterQueue());
            if (this.configuration.getTimestampAttribute() != null) {
                writeDlq = writeDlq.withTimestampAttribute(this.configuration.getTimestampAttribute());
            }
            return writeDlq;
        }

        @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> buildPubsubRead() {
            PubsubIO.Read<PubsubMessage> read = PubsubIO.readMessagesWithAttributes();
            if (this.configuration.getSubscription() != null) {
                read = read.fromSubscription(this.configuration.getSubscription());
            }
            if (this.configuration.getTopic() != null) {
                read = read.fromTopic(this.configuration.getTopic());
            }
            if (this.configuration.getTimestampAttribute() != null) {
                read = read.withTimestampAttribute(this.configuration.getTimestampAttribute());
            }
            if (this.configuration.getIdAttribute() != null) {
                read = read.withIdAttribute(this.configuration.getIdAttribute());
            }
            if (this.clientFactory != null) {
                read = read.withClientFactory(this.clientFactory);
            }
            if (this.clock != null) {
                read = read.withClock(this.clock);
            }
            return read;
        }
    }
}

