/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class SplittingIterable
implements Iterable<ProtoRows> {
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying;
    private final @UnknownKeyFor @NonNull @Initialized long splitSize;

    public SplittingIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying, @UnknownKeyFor @NonNull @Initialized long splitSize) {
        this.underlying = underlying;
        this.splitSize = splitSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ProtoRows> iterator() {
        return new Iterator<ProtoRows>(){
            final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlyingIterator;
            {
                this.underlyingIterator = SplittingIterable.this.underlying.iterator();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ProtoRows next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext()) {
                    StorageApiWritePayload payload = this.underlyingIterator.next();
                    ByteString byteString = ByteString.copyFrom((byte[])payload.getPayload());
                    inserts.addSerializedRows(byteString);
                    if ((bytesSize += (long)byteString.size()) <= SplittingIterable.this.splitSize) continue;
                    break;
                }
                return inserts.build();
            }
        };
    }
}

