/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CreateTableHelpers {
    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static @UnknownKeyFor @NonNull @Initialized TableDestination possiblyCreateTable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableSchema> schemaSupplier, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tableDestinationCoder, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        Preconditions.checkArgument((tableDestination.getTableSpec() != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() must return a TableDestination with a non-null table spec, but %s has a null table spec", (Object)tableDestination);
        boolean destinationCoderSupportsClustering = !(tableDestinationCoder instanceof TableDestinationCoderV2);
        Preconditions.checkArgument((tableDestination.getClustering() == null || destinationCoderSupportsClustering ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may only return destinations with clustering configured if a destination coder is supplied that supports clustering, but %s is configured to use TableDestinationCoderV2. Set withClustering() on BigQueryIO.write() and,  if you provided a custom DynamicDestinations instance, override getDestinationCoder() to return TableDestinationCoderV3.", (Object)tableDestination);
        TableReference tableReference = tableDestination.getTableReference().clone();
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            tableReference.setProjectId(((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class)).getProject());
            tableDestination = tableDestination.withTableReference(tableReference);
        }
        if (createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
            return tableDestination;
        }
        String tableSpec = BigQueryHelpers.stripPartitionDecorator(tableDestination.getTableSpec());
        if (!createdTables.contains(tableSpec)) {
            Set<String> set = createdTables;
            synchronized (set) {
                if (!createdTables.contains(tableSpec)) {
                    CreateTableHelpers.tryCreateTable(context, schemaSupplier, tableDestination, createDisposition, tableSpec, kmsKey, bqServices);
                }
            }
        }
        return tableDestination;
    }

    private static void tryCreateTable(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableSchema> schemaSupplier, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized String tableSpec, @Nullable @UnknownKeyFor @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        TableReference tableReference = tableDestination.getTableReference().clone();
        tableReference.setTableId(BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
        try (BigQueryServices.DatasetService datasetService = bqServices.getDatasetService((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class));){
            if (datasetService.getTable(tableReference, Collections.emptyList(), BigQueryServices.DatasetService.TableMetadataView.BASIC) == null) {
                TimePartitioning timePartitioning;
                TableSchema tableSchema = (TableSchema)schemaSupplier.get();
                org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)tableSchema, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and  %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)createDisposition), (Object)tableDestination);
                Table table = new Table().setTableReference(tableReference).setSchema(tableSchema);
                String tableDescription = tableDestination.getTableDescription();
                if (tableDescription != null) {
                    table = table.setDescription(tableDescription);
                }
                if ((timePartitioning = tableDestination.getTimePartitioning()) != null) {
                    table.setTimePartitioning(timePartitioning);
                    Clustering clustering = tableDestination.getClustering();
                    if (clustering != null) {
                        table.setClustering(clustering);
                    }
                }
                if (kmsKey != null) {
                    table.setEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
                }
                datasetService.createTable(table);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        createdTables.add(tableSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearCreatedTables() {
        Set<String> set = createdTables;
        synchronized (set) {
            createdTables.clear();
        }
    }
}

