/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auth.Credentials;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.auth.ClientAuthInterceptor;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PubsubGrpcClient
extends PubsubClient {
    private static final int LIST_BATCH_SIZE = 1000;
    private static final int DEFAULT_TIMEOUT_S = 60;
    public static final PubsubClient.PubsubClientFactory FACTORY = new PubsubGrpcClientFactory();
    private final int timeoutSec;
    private @Nullable ManagedChannel publisherChannel;
    private final Credentials credentials;
    private final @Nullable String timestampAttribute;
    private final @Nullable String idAttribute;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PublisherGrpc.PublisherBlockingStub cachedPublisherStub;
    private SubscriberGrpc.SubscriberBlockingStub cachedSubscriberStub;

    private static ManagedChannel channelForRootUrl(String urlString) throws IOException {
        String format = PubsubOptions.targetForRootUrl(urlString);
        return NettyChannelBuilder.forTarget((String)format).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().ciphers(null).build()).build();
    }

    @VisibleForTesting
    PubsubGrpcClient(@Nullable String timestampAttribute, @Nullable String idAttribute, int timeoutSec, ManagedChannel publisherChannel, Credentials credentials) {
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.timeoutSec = timeoutSec;
        this.publisherChannel = publisherChannel;
        this.credentials = credentials;
    }

    @Override
    public void close() {
        if (this.publisherChannel == null) {
            return;
        }
        this.cachedPublisherStub = null;
        this.cachedSubscriberStub = null;
        ManagedChannel publisherChannel = this.publisherChannel;
        this.publisherChannel = null;
        publisherChannel.shutdown();
        try {
            publisherChannel.awaitTermination((long)this.timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Channel newChannel() throws IOException {
        Preconditions.checkState((this.publisherChannel != null ? 1 : 0) != 0, (Object)"PubsubGrpcClient has been closed");
        ClientAuthInterceptor interceptor = new ClientAuthInterceptor(this.credentials, (Executor)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("PubsubGrpcClient-thread").build()));
        return ClientInterceptors.intercept((Channel)this.publisherChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    private PublisherGrpc.PublisherBlockingStub publisherStub() throws IOException {
        if (this.cachedPublisherStub == null) {
            this.cachedPublisherStub = PublisherGrpc.newBlockingStub((Channel)this.newChannel());
        }
        return (PublisherGrpc.PublisherBlockingStub)this.cachedPublisherStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
    }

    private SubscriberGrpc.SubscriberBlockingStub subscriberStub() throws IOException {
        if (this.cachedSubscriberStub == null) {
            this.cachedSubscriberStub = SubscriberGrpc.newBlockingStub((Channel)this.newChannel());
        }
        return (SubscriberGrpc.SubscriberBlockingStub)this.cachedSubscriberStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
    }

    @Override
    public int publish(PubsubClient.TopicPath topic, List<PubsubClient.OutgoingMessage> outgoingMessages) throws IOException {
        PublishRequest.Builder request = PublishRequest.newBuilder().setTopic(topic.getPath());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            PubsubMessage.Builder message = outgoingMessage.message().toBuilder().clearMessageId().clearPublishTime();
            if (this.timestampAttribute != null) {
                message.putAttributes(this.timestampAttribute, String.valueOf(outgoingMessage.timestampMsSinceEpoch()));
            }
            if (this.idAttribute != null && !Strings.isNullOrEmpty((String)outgoingMessage.recordId())) {
                message.putAttributes(this.idAttribute, outgoingMessage.recordId());
            }
            request.addMessages(message);
        }
        PublishResponse response = this.publisherStub().publish(request.build());
        return response.getMessageIdsCount();
    }

    @Override
    public List<PubsubClient.IncomingMessage> pull(long requestTimeMsSinceEpoch, PubsubClient.SubscriptionPath subscription, int batchSize, boolean returnImmediately) throws IOException {
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription.getPath()).setReturnImmediately(returnImmediately).setMaxMessages(batchSize).build();
        PullResponse response = this.subscriberStub().pull(request);
        if (response.getReceivedMessagesCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessagesCount());
        for (ReceivedMessage message : response.getReceivedMessagesList()) {
            long timestampMsSinceEpoch;
            PubsubMessage pubsubMessage = message.getMessage();
            @Nullable Map attributes = pubsubMessage.getAttributes();
            if (Strings.isNullOrEmpty((String)this.timestampAttribute)) {
                Timestamp timestampProto = pubsubMessage.getPublishTime();
                Preconditions.checkArgument((timestampProto != null ? 1 : 0) != 0, (Object)"Pubsub message is missing timestamp proto");
                timestampMsSinceEpoch = timestampProto.getSeconds() * 1000L + (long)timestampProto.getNanos() / 1000L / 1000L;
            } else {
                timestampMsSinceEpoch = PubsubGrpcClient.extractTimestampAttribute(this.timestampAttribute, attributes);
            }
            String ackId = message.getAckId();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)ackId) ? 1 : 0) != 0);
            String recordId = null;
            if (this.idAttribute != null && attributes != null) {
                recordId = (String)attributes.get(this.idAttribute);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            incomingMessages.add(PubsubClient.IncomingMessage.of(pubsubMessage, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(PubsubClient.SubscriptionPath subscription, List<String> ackIds) throws IOException {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).build();
        this.subscriberStub().acknowledge(request);
    }

    @Override
    public void modifyAckDeadline(PubsubClient.SubscriptionPath subscription, List<String> ackIds, int deadlineSeconds) throws IOException {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).setAckDeadlineSeconds(deadlineSeconds).build();
        this.subscriberStub().modifyAckDeadline(request);
    }

    @Override
    public void createTopic(PubsubClient.TopicPath topic) throws IOException {
        Topic request = Topic.newBuilder().setName(topic.getPath()).build();
        this.publisherStub().createTopic(request);
    }

    @Override
    public void deleteTopic(PubsubClient.TopicPath topic) throws IOException {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic.getPath()).build();
        this.publisherStub().deleteTopic(request);
    }

    @Override
    public List<PubsubClient.TopicPath> listTopics(PubsubClient.ProjectPath project) throws IOException {
        ListTopicsRequest.Builder request = ListTopicsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListTopicsResponse response = this.publisherStub().listTopics(request.build());
        if (response.getTopicsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopicsCount());
        while (true) {
            for (Topic topic : response.getTopicsList()) {
                topics.add(PubsubGrpcClient.topicPathFromPath(topic.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.publisherStub().listTopics(request.build());
        }
        return topics;
    }

    @Override
    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
        Subscription request = Subscription.newBuilder().setTopic(topic.getPath()).setName(subscription.getPath()).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.subscriberStub().createSubscription(request);
    }

    @Override
    public void deleteSubscription(PubsubClient.SubscriptionPath subscription) throws IOException {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        this.subscriberStub().deleteSubscription(request);
    }

    @Override
    public List<PubsubClient.SubscriptionPath> listSubscriptions(PubsubClient.ProjectPath project, PubsubClient.TopicPath topic) throws IOException {
        ListSubscriptionsRequest.Builder request = ListSubscriptionsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListSubscriptionsResponse response = this.subscriberStub().listSubscriptions(request.build());
        if (response.getSubscriptionsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptionsCount());
        while (true) {
            for (Subscription subscription : response.getSubscriptionsList()) {
                if (!subscription.getTopic().equals(topic.getPath())) continue;
                subscriptions.add(PubsubGrpcClient.subscriptionPathFromPath(subscription.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.subscriberStub().listSubscriptions(request.build());
        }
        return subscriptions;
    }

    @Override
    public int ackDeadlineSeconds(PubsubClient.SubscriptionPath subscription) throws IOException {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        Subscription response = this.subscriberStub().getSubscription(request);
        return response.getAckDeadlineSeconds();
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    private static class PubsubGrpcClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubGrpcClientFactory() {
        }

        @Override
        public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options) throws IOException {
            return this.newClient(timestampAttribute, idAttribute, options, null);
        }

        @Override
        public PubsubClient newClient(@Nullable String timestampAttribute, @Nullable String idAttribute, PubsubOptions options, String rootUrlOverride) throws IOException {
            return new PubsubGrpcClient(timestampAttribute, idAttribute, 60, PubsubGrpcClient.channelForRootUrl((String)MoreObjects.firstNonNull((Object)rootUrlOverride, (Object)options.getPubsubRootUrl())), options.getGcpCredential());
        }

        @Override
        public String getKind() {
            return "Grpc";
        }
    }
}

