/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_WritePartition_Result;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

class WritePartition<DestinationT>
extends DoFn<Iterable<WriteBundlesToFiles.Result<DestinationT>>, KV<ShardedKey<DestinationT>, Result>> {
    private final boolean singletonTable;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final PCollectionView<String> tempFilePrefix;
    private final int maxNumFiles;
    private final long maxSizeBytes;
    private final RowWriterFactory<?, DestinationT> rowWriterFactory;
    private TupleTag<KV<ShardedKey<DestinationT>, Result>> multiPartitionsTag;
    private TupleTag<KV<ShardedKey<DestinationT>, Result>> singlePartitionTag;

    WritePartition(boolean singletonTable, DynamicDestinations<?, DestinationT> dynamicDestinations, PCollectionView<String> tempFilePrefix, int maxNumFiles, long maxSizeBytes, TupleTag<KV<ShardedKey<DestinationT>, Result>> multiPartitionsTag, TupleTag<KV<ShardedKey<DestinationT>, Result>> singlePartitionTag, RowWriterFactory<?, DestinationT> rowWriterFactory) {
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.tempFilePrefix = tempFilePrefix;
        this.maxNumFiles = maxNumFiles;
        this.maxSizeBytes = maxSizeBytes;
        this.multiPartitionsTag = multiPartitionsTag;
        this.singlePartitionTag = singlePartitionTag;
        this.rowWriterFactory = rowWriterFactory;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        DestinationData destinationData;
        Object destination;
        ArrayList results = Lists.newArrayList((Iterable)((Iterable)c.element()));
        if (results.isEmpty() && this.singletonTable) {
            String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
            DestinationT destination2 = this.dynamicDestinations.getDestination(null);
            BigQueryRowWriter<?> bigQueryRowWriter = this.rowWriterFactory.createRowWriter(tempFilePrefix, destination2);
            bigQueryRowWriter.close();
            BigQueryRowWriter.Result writerResult = bigQueryRowWriter.getResult();
            results.add(new WriteBundlesToFiles.Result<DestinationT>(writerResult.resourceId.toString(), writerResult.byteSize, destination2));
        }
        HashMap currentResults = Maps.newHashMap();
        for (WriteBundlesToFiles.Result result : results) {
            destination = result.destination;
            destinationData = currentResults.computeIfAbsent(destination, k -> DestinationData.create(this.maxNumFiles, this.maxSizeBytes));
            PartitionData latestPartition = destinationData.getLatestPartition();
            if (!latestPartition.canAccept(1, result.fileByteSize)) {
                latestPartition = PartitionData.withMaximums(this.maxNumFiles, this.maxSizeBytes);
                destinationData.addPartition(latestPartition);
            }
            latestPartition.addFilename(result.filename);
            latestPartition.addFiles(1);
            latestPartition.addBytes(result.fileByteSize);
        }
        for (Map.Entry entry : currentResults.entrySet()) {
            destination = entry.getKey();
            destinationData = (DestinationData)entry.getValue();
            TupleTag<KV<ShardedKey<DestinationT>, Result>> outputTag = destinationData.getPartitions().size() == 1 ? this.singlePartitionTag : this.multiPartitionsTag;
            for (int i = 0; i < destinationData.getPartitions().size(); ++i) {
                PartitionData partitionData = destinationData.getPartitions().get(i);
                c.output(outputTag, (Object)KV.of((Object)ShardedKey.of(destination, (int)(i + 1)), (Object)new AutoValue_WritePartition_Result(partitionData.getFilenames(), c.pane().isFirst())));
            }
        }
    }

    private static class DestinationData {
        private List<PartitionData> partitions = Lists.newArrayList();

        private DestinationData() {
        }

        private static DestinationData create(int maxNumFiles, long maxSizeBytes) {
            DestinationData destinationData = new DestinationData();
            destinationData.partitions.add(new PartitionData(maxNumFiles, maxSizeBytes));
            return destinationData;
        }

        List<PartitionData> getPartitions() {
            return this.partitions;
        }

        PartitionData getLatestPartition() {
            return this.partitions.get(this.partitions.size() - 1);
        }

        void addPartition(PartitionData partition) {
            this.partitions.add(partition);
        }
    }

    private static class PartitionData {
        private int numFiles = 0;
        private long byteSize = 0L;
        private List<String> filenames = Lists.newArrayList();
        private final int maxNumFiles;
        private final long maxSizeBytes;

        private PartitionData(int maxNumFiles, long maxSizeBytes) {
            this.maxNumFiles = maxNumFiles;
            this.maxSizeBytes = maxSizeBytes;
        }

        static PartitionData withMaximums(int maxNumFiles, long maxSizeBytes) {
            return new PartitionData(maxNumFiles, maxSizeBytes);
        }

        int getNumFiles() {
            return this.numFiles;
        }

        void addFiles(int numFiles) {
            this.numFiles += numFiles;
        }

        long getByteSize() {
            return this.byteSize;
        }

        void addBytes(long numBytes) {
            this.byteSize += numBytes;
        }

        List<String> getFilenames() {
            return this.filenames;
        }

        void addFilename(String filename) {
            this.filenames.add(filename);
        }

        boolean canAccept(int numFiles, long numBytes) {
            if (this.filenames.isEmpty()) {
                return true;
            }
            return this.numFiles + numFiles <= this.maxNumFiles && this.byteSize + numBytes <= this.maxSizeBytes;
        }
    }

    static class ResultCoder
    extends AtomicCoder<Result> {
        private static final Coder<List<String>> FILENAMES_CODER = ListCoder.of((Coder)StringUtf8Coder.of());
        private static final Coder<Boolean> FIRST_PANE_CODER = BooleanCoder.of();
        static final ResultCoder INSTANCE = new ResultCoder();

        ResultCoder() {
        }

        public void encode(Result value, OutputStream outStream) throws IOException {
            FILENAMES_CODER.encode(value.getFilenames(), outStream);
            FIRST_PANE_CODER.encode((Object)value.isFirstPane(), outStream);
        }

        public Result decode(InputStream inStream) throws IOException {
            return new AutoValue_WritePartition_Result((List)FILENAMES_CODER.decode(inStream), (Boolean)FIRST_PANE_CODER.decode(inStream));
        }
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        public abstract List<String> getFilenames();

        abstract Boolean isFirstPane();
    }
}

