/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;

public class PartitionRestrictionMetadata
implements Serializable {
    private static final long serialVersionUID = 4744539370804123350L;
    private final String partitionToken;
    private final Timestamp partitionStartTimestamp;
    private final Timestamp partitionEndTimestamp;

    public PartitionRestrictionMetadata(String partitionToken, Timestamp partitionStartTimestamp, Timestamp partitionEndTimestamp) {
        this.partitionToken = partitionToken;
        this.partitionStartTimestamp = partitionStartTimestamp;
        this.partitionEndTimestamp = partitionEndTimestamp;
    }

    public String getPartitionToken() {
        return this.partitionToken;
    }

    public Timestamp getPartitionStartTimestamp() {
        return this.partitionStartTimestamp;
    }

    public Timestamp getPartitionEndTimestamp() {
        return this.partitionEndTimestamp;
    }

    public String toString() {
        return "PartitionRestrictionMetadata{partitionToken='" + this.partitionToken + '\'' + ", partitionStartTimestamp=" + this.partitionStartTimestamp + ", partitionEndTimestamp=" + this.partitionEndTimestamp + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PartitionRestrictionMetadata metadata) {
        return new Builder(metadata);
    }

    public static class Builder {
        private String partitionToken;
        private Timestamp partitionStartTimestamp;
        private Timestamp partitionEndTimestamp;

        public Builder() {
        }

        public Builder(PartitionRestrictionMetadata metadata) {
            this.partitionToken = metadata.partitionToken;
            this.partitionStartTimestamp = metadata.partitionStartTimestamp;
            this.partitionEndTimestamp = metadata.partitionEndTimestamp;
        }

        public Builder withPartitionToken(String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public Builder withPartitionStartTimestamp(Timestamp partitionStartTimestamp) {
            this.partitionStartTimestamp = partitionStartTimestamp;
            return this;
        }

        public Builder withPartitionEndTimestamp(Timestamp partitionEndTimestamp) {
            this.partitionEndTimestamp = partitionEndTimestamp;
            return this;
        }

        public PartitionRestrictionMetadata build() {
            return new PartitionRestrictionMetadata(this.partitionToken, this.partitionStartTimestamp, this.partitionEndTimestamp);
        }
    }
}

