/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;

class ReadSpannerSchema
extends DoFn<Void, SpannerSchema> {
    private final SpannerConfig config;
    private final PCollectionView<Dialect> dialectView;
    private transient SpannerAccessor spannerAccessor;

    public ReadSpannerSchema(SpannerConfig config, PCollectionView<Dialect> dialectView) {
        this.config = config;
        this.dialectView = dialectView;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        Dialect dialect = (Dialect)c.sideInput(this.dialectView);
        SpannerSchema.Builder builder = SpannerSchema.builder(dialect);
        DatabaseClient databaseClient = this.spannerAccessor.getDatabaseClient();
        try (ReadOnlyTransaction tx = databaseClient.readOnlyTransaction();){
            String columnName;
            String tableName;
            ResultSet resultSet = this.readTableInfo(tx, dialect);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String type = resultSet.getString(2);
                long cellsMutated = resultSet.getLong(3);
                builder.addColumn(tableName, columnName, type, cellsMutated);
            }
            resultSet = this.readPrimaryKeyInfo(tx, dialect);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String ordering = resultSet.getString(2);
                builder.addKeyPart(tableName, columnName, "DESC".equalsIgnoreCase(ordering));
            }
        }
        c.output((Object)builder.build());
    }

    private ResultSet readTableInfo(ReadOnlyTransaction tx, Dialect dialect) {
        String statement = "";
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                statement = "SELECT    c.table_name  , c.column_name  , c.spanner_type  , (1 + COALESCE(t.indices, 0)) AS cells_mutated  FROM (    SELECT c.table_name, c.column_name, c.spanner_type, c.ordinal_position     FROM information_schema.columns as c     WHERE c.table_catalog = '' AND c.table_schema = '') AS c  LEFT OUTER JOIN (    SELECT t.table_name, t.column_name, COUNT(*) AS indices      FROM information_schema.index_columns AS t       WHERE t.index_name != 'PRIMARY_KEY' AND t.table_catalog = ''      AND t.table_schema = ''      GROUP BY t.table_name, t.column_name) AS t  USING (table_name, column_name)  ORDER BY c.table_name, c.ordinal_position";
                break;
            }
            case POSTGRESQL: {
                statement = "SELECT    c.table_name  , c.column_name  , c.spanner_type  , (1 + COALESCE(t.indices, 0)) AS cells_mutated  FROM (    SELECT c.table_name, c.column_name, c.spanner_type, c.ordinal_position      FROM information_schema.columns as c      WHERE c.table_schema NOT IN      ('information_schema', 'spanner_sys', 'pg_catalog')) AS c  LEFT OUTER JOIN (    SELECT t.table_name, t.column_name, COUNT(*) AS indices      FROM information_schema.index_columns AS t       WHERE t.index_name != 'PRIMARY_KEY'      AND t.table_schema NOT IN      ('information_schema', 'spanner_sys', 'pg_catalog')      GROUP BY t.table_name, t.column_name) AS t  USING (table_name, column_name)  ORDER BY c.table_name, c.ordinal_position";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
            }
        }
        return tx.executeQuery(Statement.of((String)statement), new Options.QueryOption[0]);
    }

    private ResultSet readPrimaryKeyInfo(ReadOnlyTransaction tx, Dialect dialect) {
        String statement = "";
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                statement = "SELECT t.table_name, t.column_name, t.column_ordering FROM information_schema.index_columns AS t  WHERE t.index_name = 'PRIMARY_KEY' AND t.table_catalog = '' AND t.table_schema = '' ORDER BY t.table_name, t.ordinal_position";
                break;
            }
            case POSTGRESQL: {
                statement = "SELECT t.table_name, t.column_name, t.column_ordering FROM information_schema.index_columns AS t  WHERE t.index_name = 'PRIMARY_KEY' AND t.table_schema NOT IN ('information_schema', 'spanner_sys', 'pg_catalog') ORDER BY t.table_name, t.ordinal_position";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
            }
        }
        return tx.executeQuery(Statement.of((String)statement), new Options.QueryOption[0]);
    }
}

