/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class NestedRowToMessage
extends SimpleFunction<Row, PubsubMessage> {
    private static final long serialVersionUID = 65176815766314684L;
    private final PayloadSerializer serializer;
    private final SerializableFunction<Row, Map<String, String>> attributesExtractor;
    private final SerializableFunction<Row, byte[]> payloadExtractor;

    NestedRowToMessage(PayloadSerializer serializer, Schema schema) {
        this.serializer = serializer;
        if (schema.getField("attributes").getType().equals((Object)PubsubSchemaIOProvider.ATTRIBUTE_MAP_FIELD_TYPE)) {
            this.attributesExtractor = NestedRowToMessage::getAttributesFromMap;
        } else {
            org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((boolean)schema.getField("attributes").getType().equals((Object)PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_FIELD_TYPE));
            this.attributesExtractor = NestedRowToMessage::getAttributesFromArray;
        }
        if (schema.getField("payload").getType().equals((Object)Schema.FieldType.BYTES)) {
            this.payloadExtractor = NestedRowToMessage::getPayloadFromBytes;
        } else {
            org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((boolean)schema.getField("payload").getType().getTypeName().equals((Object)Schema.TypeName.ROW));
            this.payloadExtractor = this::getPayloadFromNested;
        }
    }

    private static Map<String, String> getAttributesFromMap(Row row) {
        return ImmutableMap.builder().putAll((Map)Preconditions.checkArgumentNotNull((Object)row.getMap("attributes"))).build();
    }

    private static Map<String, String> getAttributesFromArray(Row row) {
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        Collection attributeEntries = (Collection)Preconditions.checkArgumentNotNull((Object)row.getArray("attributes"));
        for (Row entry : attributeEntries) {
            attributes.put((Object)((String)Preconditions.checkArgumentNotNull((Object)entry.getString("key"))), (Object)((String)Preconditions.checkArgumentNotNull((Object)entry.getString("value"))));
        }
        return attributes.build();
    }

    private static byte[] getPayloadFromBytes(Row row) {
        return (byte[])Preconditions.checkArgumentNotNull((Object)row.getBytes("payload"));
    }

    private byte[] getPayloadFromNested(Row row) {
        return this.serializer.serialize((Row)Preconditions.checkArgumentNotNull((Object)row.getRow("payload")));
    }

    public PubsubMessage apply(Row row) {
        return new PubsubMessage((byte[])this.payloadExtractor.apply((Object)row), (Map)this.attributesExtractor.apply((Object)row));
    }
}

