/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class HealthcareIOErrorToTableRow<T>
implements SerializableFunction<HealthcareIOError<T>, TableRow> {
    private static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTime();
    public static final String TIMESTAMP_FIELD_NAME = "observed_time";
    public static final List<TableFieldSchema> TABLE_FIELD_SCHEMAS = Stream.of(Pair.of((Object)"dataElement", (Object)"STRING"), Pair.of((Object)"observed_time", (Object)"TIMESTAMP"), Pair.of((Object)"message", (Object)"STRING"), Pair.of((Object)"stacktrace", (Object)"STRING"), Pair.of((Object)"statusCode", (Object)"INTEGER")).map(field -> {
        TableFieldSchema tfs = new TableFieldSchema();
        tfs.setName((String)field.getKey());
        tfs.setMode("NULLABLE");
        tfs.setType((String)field.getValue());
        return tfs;
    }).collect(Collectors.toList());

    public TableRow apply(HealthcareIOError<T> err) {
        TableRow out = new TableRow();
        out.set("dataElement", (Object)err.getDataResource().toString());
        out.set(TIMESTAMP_FIELD_NAME, (Object)err.getObservedTime().toString(DATETIME_FORMATTER));
        out.set("message", (Object)err.getErrorMessage());
        out.set("stacktrace", (Object)err.getStackTrace());
        out.set("statusCode", (Object)err.getStatusCode());
        return out;
    }
}

