/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.util.UUID;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;

@VisibleForTesting
class TagWithUniqueIds<KeyT, ElementT>
extends DoFn<KV<KeyT, ElementT>, KV<KeyT, TableRowInfo<ElementT>>> {
    private transient @Nullable String randomUUID = null;
    private transient long sequenceNo = 0L;
    private final @Nullable SerializableFunction<ElementT, String> elementToId;

    public TagWithUniqueIds() {
        this.elementToId = null;
    }

    public TagWithUniqueIds(@Nullable SerializableFunction<ElementT, String> elementToId) {
        this.elementToId = elementToId;
    }

    @DoFn.StartBundle
    public void startBundle() {
        if (this.elementToId == null) {
            this.randomUUID = UUID.randomUUID().toString();
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) throws IOException {
        String uniqueId = this.elementToId == null ? this.randomUUID + this.sequenceNo++ : (String)this.elementToId.apply(((KV)context.element()).getValue());
        context.output((Object)KV.of((Object)((KV)context.element()).getKey(), new TableRowInfo<Object>(((KV)context.element()).getValue(), uniqueId)));
    }
}

