/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.core.ApiFuture;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public interface BigQueryServices
extends Serializable {
    public JobService getJobService(BigQueryOptions var1);

    public DatasetService getDatasetService(BigQueryOptions var1);

    public StorageClient getStorageClient(BigQueryOptions var1) throws IOException;

    public static interface StorageClient
    extends AutoCloseable {
        public ReadSession createReadSession(CreateReadSessionRequest var1);

        public BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest var1);

        public BigQueryServerStream<ReadRowsResponse> readRows(ReadRowsRequest var1, String var2);

        public SplitReadStreamResponse splitReadStream(SplitReadStreamRequest var1);

        public SplitReadStreamResponse splitReadStream(SplitReadStreamRequest var1, String var2);

        @Override
        public void close();
    }

    public static interface BigQueryServerStream<T>
    extends Iterable<T>,
    Serializable {
        public void cancel();
    }

    public static interface StreamAppendClient
    extends AutoCloseable {
        public ApiFuture<AppendRowsResponse> appendRows(long var1, ProtoRows var3) throws Exception;

        default public long getInflightWaitSeconds() {
            return 0L;
        }

        public void pin();

        public void unpin() throws Exception;
    }

    public static interface DatasetService
    extends AutoCloseable {
        public @Nullable Table getTable(TableReference var1) throws InterruptedException, IOException;

        public @Nullable Table getTable(TableReference var1, List<String> var2) throws InterruptedException, IOException;

        public @Nullable Table getTable(TableReference var1, List<String> var2, TableMetadataView var3) throws InterruptedException, IOException;

        public void createTable(Table var1) throws InterruptedException, IOException;

        public void deleteTable(TableReference var1) throws IOException, InterruptedException;

        public boolean isTableEmpty(TableReference var1) throws IOException, InterruptedException;

        public Dataset getDataset(String var1, String var2) throws IOException, InterruptedException;

        public void createDataset(String var1, String var2, @Nullable String var3, @Nullable String var4, @Nullable Long var5) throws IOException, InterruptedException;

        public void deleteDataset(String var1, String var2) throws IOException, InterruptedException;

        public <T> long insertAll(TableReference var1, List<FailsafeValueInSingleWindow<TableRow, TableRow>> var2, @Nullable List<String> var3, InsertRetryPolicy var4, List<ValueInSingleWindow<T>> var5, ErrorContainer<T> var6, boolean var7, boolean var8, boolean var9, List<ValueInSingleWindow<TableRow>> var10) throws IOException, InterruptedException;

        public Table patchTableDescription(TableReference var1, @Nullable String var2) throws IOException, InterruptedException;

        public WriteStream createWriteStream(String var1, WriteStream.Type var2) throws IOException, InterruptedException;

        public StreamAppendClient getStreamAppendClient(String var1, Descriptors.Descriptor var2) throws Exception;

        public ApiFuture<FlushRowsResponse> flush(String var1, long var2) throws IOException, InterruptedException;

        public ApiFuture<FinalizeWriteStreamResponse> finalizeWriteStream(String var1);

        public ApiFuture<BatchCommitWriteStreamsResponse> commitWriteStreams(String var1, Iterable<String> var2);

        public static enum TableMetadataView {
            TABLE_METADATA_VIEW_UNSPECIFIED,
            BASIC,
            STORAGE_STATS,
            FULL;

        }
    }

    public static interface JobService
    extends AutoCloseable {
        public void startLoadJob(JobReference var1, JobConfigurationLoad var2) throws InterruptedException, IOException;

        public void startLoadJob(JobReference var1, JobConfigurationLoad var2, AbstractInputStreamContent var3) throws InterruptedException, IOException;

        public void startExtractJob(JobReference var1, JobConfigurationExtract var2) throws InterruptedException, IOException;

        public void startQueryJob(JobReference var1, JobConfigurationQuery var2) throws IOException, InterruptedException;

        public void startCopyJob(JobReference var1, JobConfigurationTableCopy var2) throws IOException, InterruptedException;

        public Job pollJob(JobReference var1, int var2) throws InterruptedException;

        public JobStatistics dryRunQuery(String var1, JobConfigurationQuery var2, @Nullable String var3) throws InterruptedException, IOException;

        public Job getJob(JobReference var1) throws IOException, InterruptedException;
    }
}

