/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WriteResult
implements POutput {
    private final Pipeline pipeline;
    private final @Nullable TupleTag<TableRow> failedInsertsTag;
    private final @Nullable PCollection<TableRow> failedInserts;
    private final @Nullable TupleTag<BigQueryInsertError> failedInsertsWithErrTag;
    private final @Nullable PCollection<BigQueryInsertError> failedInsertsWithErr;
    private final @Nullable PCollection<TableRow> successfulInserts;
    private final @Nullable TupleTag<TableDestination> successfulBatchInsertsTag;
    private final @Nullable PCollection<TableDestination> successfulBatchInserts;
    private final @Nullable TupleTag<BigQueryStorageApiInsertError> failedStorageApiInsertsTag;
    private final @Nullable PCollection<BigQueryStorageApiInsertError> failedStorageApiInserts;

    static WriteResult in(Pipeline pipeline, @Nullable TupleTag<TableRow> failedInsertsTag, @Nullable PCollection<TableRow> failedInserts, @Nullable PCollection<TableRow> successfulInserts, @Nullable TupleTag<TableDestination> successfulBatchInsertsTag, @Nullable PCollection<TableDestination> successfulBatchInserts, @Nullable TupleTag<BigQueryStorageApiInsertError> failedStorageApiInsertsTag, @Nullable PCollection<BigQueryStorageApiInsertError> failedStorageApiInserts) {
        return new WriteResult(pipeline, failedInsertsTag, failedInserts, null, null, successfulInserts, successfulBatchInsertsTag, successfulBatchInserts, failedStorageApiInsertsTag, failedStorageApiInserts);
    }

    static WriteResult withExtendedErrors(Pipeline pipeline, TupleTag<BigQueryInsertError> failedInsertsTag, PCollection<BigQueryInsertError> failedInserts, PCollection<TableRow> successfulInserts) {
        return new WriteResult(pipeline, null, null, failedInsertsTag, failedInserts, successfulInserts, null, null, null, null);
    }

    public Map<TupleTag<?>, PValue> expand() {
        ImmutableMap.Builder output = ImmutableMap.builder();
        if (this.failedInsertsTag != null) {
            output.put(this.failedInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedInserts)));
        } else if (this.failedInsertsWithErrTag != null) {
            output.put(this.failedInsertsWithErrTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedInsertsWithErr)));
        }
        if (this.failedStorageApiInsertsTag != null) {
            output.put(this.failedStorageApiInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.failedStorageApiInserts)));
        }
        if (this.successfulBatchInsertsTag != null) {
            output.put(this.successfulBatchInsertsTag, (Object)((PValue)Preconditions.checkArgumentNotNull(this.successfulBatchInserts)));
        }
        return output.build();
    }

    private WriteResult(Pipeline pipeline, @Nullable TupleTag<TableRow> failedInsertsTag, @Nullable PCollection<TableRow> failedInserts, @Nullable TupleTag<BigQueryInsertError> failedInsertsWithErrTag, @Nullable PCollection<BigQueryInsertError> failedInsertsWithErr, @Nullable PCollection<TableRow> successfulInserts, @Nullable TupleTag<TableDestination> successfulInsertsTag, @Nullable PCollection<TableDestination> successfulBatchInserts, @Nullable TupleTag<BigQueryStorageApiInsertError> failedStorageApiInsertsTag, @Nullable PCollection<BigQueryStorageApiInsertError> failedStorageApiInserts) {
        this.pipeline = pipeline;
        this.failedInsertsTag = failedInsertsTag;
        this.failedInserts = failedInserts;
        this.failedInsertsWithErrTag = failedInsertsWithErrTag;
        this.failedInsertsWithErr = failedInsertsWithErr;
        this.successfulInserts = successfulInserts;
        this.successfulBatchInsertsTag = successfulInsertsTag;
        this.successfulBatchInserts = successfulBatchInserts;
        this.failedStorageApiInsertsTag = failedStorageApiInsertsTag;
        this.failedStorageApiInserts = failedStorageApiInserts;
    }

    public PCollection<TableDestination> getSuccessfulTableLoads() {
        Preconditions.checkArgumentNotNull(this.successfulBatchInsertsTag, (Object)"Cannot use getSuccessfulTableLoads because this WriteResult was not configured to produce them.  Note: only batch loads produce successfulTableLoads.");
        return (PCollection)Preconditions.checkArgumentNotNull(this.successfulBatchInserts, (Object)"Cannot use getSuccessfulTableLoads because this WriteResult was not configured to produce them.  Note: only batch loads produce successfulTableLoads.");
    }

    public PCollection<TableRow> getSuccessfulInserts() {
        if (this.successfulInserts == null) {
            throw new IllegalStateException("Retrieving successful inserts is only supported for streaming inserts.");
        }
        return this.successfulInserts;
    }

    public PCollection<TableRow> getFailedInserts() {
        Preconditions.checkArgumentNotNull(this.failedInsertsTag, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead");
        return (PCollection)Preconditions.checkStateNotNull(this.failedInserts, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead");
    }

    public PCollection<BigQueryInsertError> getFailedInsertsWithErr() {
        Preconditions.checkArgumentNotNull(this.failedInsertsWithErrTag, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead");
        return (PCollection)Preconditions.checkArgumentNotNull(this.failedInsertsWithErr, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead");
    }

    public PCollection<BigQueryStorageApiInsertError> getFailedStorageApiInserts() {
        Preconditions.checkStateNotNull(this.failedStorageApiInsertsTag, (Object)"Cannot use getFailedStorageApiInserts as this insert didn't use the storage API.");
        return (PCollection)Preconditions.checkStateNotNull(this.failedStorageApiInserts, (Object)"Cannot use getFailedStorageApiInserts as this insert didn't use the storage API.");
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
    }
}

