/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TableRowToStorageApiProto {
    private static final DateTimeFormatter DATETIME_SPACE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSS").withZone(ZoneOffset.UTC);
    static final Map<String, DescriptorProtos.FieldDescriptorProto.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)"INT64", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"INTEGER", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"FLOAT64", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)"FLOAT", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)"STRING", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"BOOL", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)"BOOLEAN", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)"BYTES", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)"NUMERIC", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)"BIGNUMERIC", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)"GEOGRAPHY", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"DATE", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)"TIME", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"DATETIME", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"TIMESTAMP", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"JSON", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build();

    public static Descriptors.Descriptor getDescriptorFromTableSchema(TableSchema jsonSchema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto descriptorProto = TableRowToStorageApiProto.descriptorSchemaFromTableSchema(jsonSchema);
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        return (Descriptors.Descriptor)Iterables.getOnlyElement((Iterable)fileDescriptor.getMessageTypes());
    }

    public static DynamicMessage messageFromMap(SchemaInformation schemaInformation, Descriptors.Descriptor descriptor, AbstractMap<String, Object> map, boolean ignoreUnknownValues) throws SchemaConversionException {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(entry.getKey().toLowerCase());
            if (fieldDescriptor == null) {
                if (ignoreUnknownValues) continue;
                throw new SchemaTooNarrowException("TableRow contained unexpected field with name " + entry.getKey() + " not found in schema for " + schemaInformation.getFullName());
            }
            SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(entry.getKey());
            try {
                @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, entry.getValue(), ignoreUnknownValues);
                if (value == null) continue;
                builder.setField(fieldDescriptor, value);
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
            }
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            throw new SchemaDoesntMatchException("Couldn't convert schema for " + schemaInformation.getFullName(), e);
        }
    }

    public static DynamicMessage messageFromTableRow(SchemaInformation schemaInformation, Descriptors.Descriptor descriptor, TableRow tableRow, boolean ignoreUnkownValues) throws SchemaConversionException {
        @Nullable Object fValue = tableRow.get((Object)"f");
        if (fValue instanceof List) {
            List cells = (List)fValue;
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            int cellsToProcess = cells.size();
            if (cells.size() > descriptor.getFields().size()) {
                if (ignoreUnkownValues) {
                    cellsToProcess = descriptor.getFields().size();
                } else {
                    throw new SchemaTooNarrowException("TableRow contained too many fields and ignoreUnknownValues not set.");
                }
            }
            for (int i = 0; i < cellsToProcess; ++i) {
                AbstractMap cell = (AbstractMap)cells.get(i);
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor.getFields().get(i);
                SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(i);
                try {
                    @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, cell.get("v"), ignoreUnkownValues);
                    if (value == null) continue;
                    builder.setField(fieldDescriptor, value);
                    continue;
                }
                catch (Exception e) {
                    throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
                }
            }
            try {
                return builder.build();
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Could convert schema for " + schemaInformation.getFullName(), e);
            }
        }
        return TableRowToStorageApiProto.messageFromMap(schemaInformation, descriptor, (AbstractMap<String, Object>)tableRow, ignoreUnkownValues);
    }

    @VisibleForTesting
    static DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(TableSchema tableSchema) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(tableSchema.getFields());
    }

    private static DescriptorProtos.DescriptorProto descriptorSchemaFromTableFieldSchemas(Iterable<TableFieldSchema> tableFieldSchemas) {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName("D" + UUID.randomUUID().toString().replace("-", "_"));
        int i = 1;
        for (TableFieldSchema fieldSchema : tableFieldSchemas) {
            TableRowToStorageApiProto.fieldDescriptorFromTableField(fieldSchema, i++, descriptorBuilder);
        }
        return descriptorBuilder.build();
    }

    private static void fieldDescriptorFromTableField(TableFieldSchema fieldSchema, int fieldNumber, DescriptorProtos.DescriptorProto.Builder descriptorBuilder) {
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        fieldDescriptorBuilder = fieldDescriptorBuilder.setName(fieldSchema.getName().toLowerCase());
        fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(fieldNumber);
        switch (fieldSchema.getType()) {
            case "STRUCT": 
            case "RECORD": {
                DescriptorProtos.DescriptorProto nested = TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(fieldSchema.getFields());
                descriptorBuilder.addNestedType(nested);
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            default: {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable DescriptorProtos.FieldDescriptorProto.Type type = PRIMITIVE_TYPES.get(fieldSchema.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("Converting BigQuery type " + fieldSchema.getType() + " to Beam type is unsupported");
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(type);
            }
        }
        Optional<Mode> fieldMode = Optional.ofNullable(fieldSchema.getMode()).map(Mode::valueOf);
        fieldDescriptorBuilder = fieldMode.filter(m -> m == Mode.REPEATED).isPresent() ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) : (!fieldMode.isPresent() || fieldMode.filter(m -> m == Mode.NULLABLE).isPresent() ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL) : fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED));
        descriptorBuilder.addField(fieldDescriptorBuilder.build());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable Object messageValueFromFieldValue(SchemaInformation schemaInformation, Descriptors.FieldDescriptor fieldDescriptor, @Nullable Object bqValue, boolean ignoreUnknownValues) throws SchemaConversionException {
        if (bqValue == null) {
            if (fieldDescriptor.isOptional()) {
                return null;
            }
            if (fieldDescriptor.isRepeated()) {
                return Collections.emptyList();
            }
            throw new SchemaDoesntMatchException("Received null value for non-nullable field " + schemaInformation.getFullName());
        }
        if (fieldDescriptor.isRepeated()) {
            List listValue = (List)bqValue;
            @Nullable ArrayList protoList = Lists.newArrayListWithCapacity((int)listValue.size());
            for (Object o : listValue) {
                if (o == null) continue;
                protoList.add(TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, o, ignoreUnknownValues));
            }
            return protoList;
        }
        return TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, bqValue, ignoreUnknownValues);
    }

    @VisibleForTesting
    static @Nullable Object singularFieldToProtoValue(SchemaInformation schemaInformation, Descriptors.FieldDescriptor fieldDescriptor, @Nullable Object value, boolean ignoreUnknownValues) throws SchemaConversionException {
        switch (schemaInformation.getType()) {
            case "INT64": 
            case "INTEGER": {
                if (value instanceof String) {
                    return Long.valueOf((String)value);
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return ((Number)value).longValue();
            }
            case "FLOAT64": 
            case "FLOAT": {
                if (value instanceof String) {
                    return Double.valueOf((String)value);
                }
                if (!(value instanceof Number)) break;
                return ((Number)value).doubleValue();
            }
            case "BOOLEAN": 
            case "BOOL": {
                if (value instanceof String) {
                    return Boolean.valueOf((String)value);
                }
                if (!(value instanceof Boolean)) break;
                return value;
            }
            case "BYTES": {
                if (value instanceof String) {
                    return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)((String)value)));
                }
                if (value instanceof byte[]) {
                    return ByteString.copyFrom((byte[])((byte[])value));
                }
                if (!(value instanceof ByteString)) break;
                return value;
            }
            case "TIMESTAMP": {
                if (value instanceof String) {
                    try {
                        return ChronoUnit.MICROS.between(Instant.EPOCH, Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse((String)value)));
                    }
                    catch (DateTimeParseException e) {
                        try {
                            return ChronoUnit.MICROS.between(Instant.EPOCH, Instant.ofEpochMilli(Long.parseLong((String)value)));
                        }
                        catch (NumberFormatException e2) {
                            return ChronoUnit.MICROS.between(Instant.EPOCH, Instant.from(DATETIME_SPACE_FORMATTER.parse((String)value)));
                        }
                    }
                }
                if (value instanceof Instant) {
                    return ChronoUnit.MICROS.between(Instant.EPOCH, (Instant)value);
                }
                if (value instanceof org.joda.time.Instant) {
                    return ((org.joda.time.Instant)value).getMillis() * 1000L;
                }
                if (value instanceof Integer || value instanceof Long) {
                    return ((Number)value).longValue();
                }
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return BigDecimal.valueOf(((Number)value).doubleValue()).scaleByPowerOfTen(6).setScale(0, RoundingMode.HALF_UP).longValue();
            }
            case "DATE": {
                if (value instanceof String) {
                    return Long.valueOf(LocalDate.parse((String)value).toEpochDay()).intValue();
                }
                if (value instanceof LocalDate) {
                    return Long.valueOf(((LocalDate)value).toEpochDay()).intValue();
                }
                if (value instanceof org.joda.time.LocalDate) {
                    return Days.daysBetween((ReadablePartial)org.joda.time.Instant.EPOCH.toDateTime().toLocalDate(), (ReadablePartial)((org.joda.time.LocalDate)value)).getDays();
                }
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return ((Number)value).intValue();
            }
            case "NUMERIC": {
                if (value instanceof String) {
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal((String)value));
                }
                if (value instanceof BigDecimal) {
                    return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)((BigDecimal)value));
                }
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
            }
            case "BIGNUMERIC": {
                if (value instanceof String) {
                    return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)new BigDecimal((String)value));
                }
                if (value instanceof BigDecimal) {
                    return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)((BigDecimal)value));
                }
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
            }
            case "DATETIME": {
                if (value instanceof String) {
                    try {
                        return CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((String)value));
                    }
                    catch (DateTimeParseException e2) {
                        return CivilTimeEncoder.encodePacked64DatetimeMicros(LocalDateTime.parse((String)value, DATETIME_SPACE_FORMATTER));
                    }
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof LocalDateTime) {
                    return CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)value);
                }
                if (!(value instanceof org.joda.time.LocalDateTime)) break;
                return CivilTimeEncoder.encodePacked64DatetimeMicros((org.joda.time.LocalDateTime)value);
            }
            case "TIME": {
                if (value instanceof String) {
                    return CivilTimeEncoder.encodePacked64TimeMicros(java.time.LocalTime.parse((String)value));
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof java.time.LocalTime) {
                    return CivilTimeEncoder.encodePacked64TimeMicros((java.time.LocalTime)value);
                }
                if (!(value instanceof LocalTime)) break;
                return CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value);
            }
            case "STRING": 
            case "JSON": 
            case "GEOGRAPHY": {
                return Preconditions.checkArgumentNotNull((Object)value).toString();
            }
            case "STRUCT": 
            case "RECORD": {
                if (value instanceof TableRow) {
                    TableRow tableRow = (TableRow)value;
                    return TableRowToStorageApiProto.messageFromTableRow(schemaInformation, fieldDescriptor.getMessageType(), tableRow, ignoreUnknownValues);
                }
                if (!(value instanceof AbstractMap)) break;
                AbstractMap map = (AbstractMap)value;
                return TableRowToStorageApiProto.messageFromMap(schemaInformation, fieldDescriptor.getMessageType(), map, ignoreUnknownValues);
            }
        }
        throw new SchemaDoesntMatchException("Unexpected value :" + value + ", type: " + (value == null ? "null" : value.getClass()) + ". Table field name: " + schemaInformation.getFullName() + ", type: " + schemaInformation.getType());
    }

    @VisibleForTesting
    public static TableRow tableRowFromMessage(Message message) {
        TableRow tableRow = new TableRow();
        for (Map.Entry field : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)field.getKey();
            Object fieldValue = field.getValue();
            tableRow.putIfAbsent((Object)fieldDescriptor.getName(), TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, fieldValue, true));
        }
        return tableRow;
    }

    public static Object jsonValueFromMessageValue(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue, boolean expandRepeated) {
        if (expandRepeated && fieldDescriptor.isRepeated()) {
            List valueList = (List)fieldValue;
            return valueList.stream().map(v -> TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, v, false)).collect(Collectors.toList());
        }
        switch (fieldDescriptor.getType()) {
            case GROUP: 
            case MESSAGE: {
                return TableRowToStorageApiProto.tableRowFromMessage((Message)fieldValue);
            }
            case BYTES: {
                return BaseEncoding.base64().encode(((ByteString)fieldValue).toByteArray());
            }
            case ENUM: {
                throw new RuntimeException("Enumerations not supported");
            }
        }
        return fieldValue.toString();
    }

    static class SchemaInformation {
        private final TableFieldSchema tableFieldSchema;
        private final List<SchemaInformation> subFields;
        private final Map<String, SchemaInformation> subFieldsByName;
        private final Iterable<SchemaInformation> parentSchemas;

        private SchemaInformation(TableFieldSchema tableFieldSchema) {
            this(tableFieldSchema, Collections.emptyList());
        }

        private SchemaInformation(TableFieldSchema tableFieldSchema, Iterable<SchemaInformation> parentSchemas) {
            this.tableFieldSchema = tableFieldSchema;
            this.subFields = Lists.newArrayList();
            this.subFieldsByName = Maps.newHashMap();
            this.parentSchemas = parentSchemas;
            if (tableFieldSchema.getFields() != null) {
                for (TableFieldSchema field : tableFieldSchema.getFields()) {
                    SchemaInformation schemaInformation = new SchemaInformation(field, Iterables.concat(this.parentSchemas, (Iterable)ImmutableList.of((Object)this)));
                    this.subFields.add(schemaInformation);
                    this.subFieldsByName.put(field.getName(), schemaInformation);
                }
            }
        }

        public String getFullName() {
            String prefix = StreamSupport.stream(this.parentSchemas.spliterator(), false).map(SchemaInformation::getName).collect(Collectors.joining("."));
            return prefix.isEmpty() ? this.getName() : prefix + "." + this.getName();
        }

        public String getName() {
            return this.tableFieldSchema.getName();
        }

        public String getType() {
            return this.tableFieldSchema.getType();
        }

        public SchemaInformation getSchemaForField(String name) {
            SchemaInformation schemaInformation = this.subFieldsByName.get(name);
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + name);
            }
            return schemaInformation;
        }

        public SchemaInformation getSchemaForField(int i) {
            SchemaInformation schemaInformation = this.subFields.get(i);
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + i);
            }
            return schemaInformation;
        }

        static SchemaInformation fromTableSchema(TableSchema tableSchema) {
            TableFieldSchema rootSchema = new TableFieldSchema().setName("__root__").setType("RECORD").setFields(tableSchema.getFields());
            return new SchemaInformation(rootSchema);
        }
    }

    public static class SchemaDoesntMatchException
    extends SchemaConversionException {
        SchemaDoesntMatchException(String msg) {
            super(msg);
        }

        SchemaDoesntMatchException(String msg, Exception e) {
            super(msg + ". Exception: " + e, e);
        }
    }

    public static class SchemaTooNarrowException
    extends SchemaConversionException {
        SchemaTooNarrowException(String msg) {
            super(msg);
        }
    }

    public static class SchemaConversionException
    extends Exception {
        SchemaConversionException(String msg) {
            super(msg);
        }

        SchemaConversionException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

