/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageArrowReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageAvroReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;

class BigQueryStorageReaderFactory {
    private BigQueryStorageReaderFactory() {
    }

    public static BigQueryStorageReader getReader(ReadSession readSession) throws IOException {
        if (readSession.hasAvroSchema()) {
            return new BigQueryStorageAvroReader(readSession);
        }
        if (readSession.hasArrowSchema()) {
            return new BigQueryStorageArrowReader(readSession);
        }
        throw new IllegalStateException("Read session does not have Avro/Arrow schema set.");
    }
}

