/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Internal
public class PubsubDlqProvider
implements GenericDlqProvider {
    public String identifier() {
        return "pubsub";
    }

    public PTransform<PCollection<Failure>, PDone> newDlqTransform(String config) {
        return new DlqTransform(config);
    }

    private static class DlqTransform
    extends PTransform<PCollection<Failure>, PDone> {
        private final String topic;

        DlqTransform(String topic) {
            this.topic = topic;
        }

        public PDone expand(PCollection<Failure> input) {
            return (PDone)((PCollection)input.apply("Failure to PubsubMessage", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via(DlqTransform::getMessage))).apply("Write Failures to Pub/Sub", PubsubIO.writeMessages().to(this.topic));
        }

        private static PubsubMessage getMessage(Failure failure) {
            return new PubsubMessage(failure.getPayload(), (Map<String, String>)ImmutableMap.of((Object)"beam-dlq-error", (Object)failure.getError()));
        }
    }
}

