/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameterCoder;
import org.checkerframework.checker.nullness.qual.Nullable;

@DefaultCoder(value=FhirSearchParameterCoder.class)
public class FhirSearchParameter<T> {
    private final String resourceType;
    private final String key;
    private final @Nullable Map<String, T> queries;

    private FhirSearchParameter(String resourceType, @Nullable String key, @Nullable Map<String, T> queries) {
        this.resourceType = resourceType;
        this.key = key != null ? key : "";
        this.queries = queries;
    }

    public static <T> FhirSearchParameter<T> of(String resourceType, @Nullable String key, @Nullable Map<String, T> queries) {
        return new FhirSearchParameter<T>(resourceType, key, queries);
    }

    public static <T> FhirSearchParameter<T> of(String resourceType, @Nullable Map<String, T> queries) {
        return new FhirSearchParameter<T>(resourceType, null, queries);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getKey() {
        return this.key;
    }

    public @Nullable Map<String, T> getQueries() {
        return this.queries;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FhirSearchParameter that = (FhirSearchParameter)o;
        return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.key, that.key) && Objects.equals(this.queries, that.queries);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.queries);
    }

    public String toString() {
        return "FhirSearchParameter{resourceType='" + this.resourceType + '\'' + ", key='" + this.key + '\'' + ", queries=" + this.queries + '}';
    }
}

