/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigQueryDlqProvider
implements GenericDlqProvider {
    public String identifier() {
        return "bigquery";
    }

    public PTransform<PCollection<Failure>, PDone> newDlqTransform(String config) {
        return new DlqTransform(config);
    }

    private static class DlqTransform
    extends PTransform<PCollection<Failure>, PDone> {
        private static final Logger LOG = LoggerFactory.getLogger(BigQueryDlqProvider.class);
        private final String tableSpec;

        DlqTransform(String tableSpec) {
            this.tableSpec = tableSpec;
        }

        public PDone expand(PCollection<Failure> input) {
            ((WriteResult)((PCollection)input.apply("Failure to Row", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via(DlqTransform::getTableRow))).apply("Write Failures to BigQuery", BigQueryIO.writeTableRows().to(this.tableSpec))).getFailedInsertsWithErr().apply("Log insert failures", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Void.class)).via((SerializableFunction & Serializable)x -> {
                LOG.error("Failed to insert error into BigQuery table. {}", x);
                return null;
            }));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static TableRow getTableRow(Failure failure) {
            Row row = Row.withSchema((Schema)Schema.builder().addByteArrayField("payload").addStringField("error").build()).withFieldValue("payload", (Object)failure.getPayload()).withFieldValue("error", (Object)failure.getError()).build();
            return BigQueryUtils.toTableRow(row);
        }
    }
}

