/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.TimestampBound;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.values.PCollectionView;

final class AutoValue_SpannerIO_Read
extends SpannerIO.Read {
    private final SpannerConfig spannerConfig;
    private final ReadOperation readOperation;
    private final TimestampBound timestampBound;
    private final PCollectionView<Transaction> transaction;

    private AutoValue_SpannerIO_Read(SpannerConfig spannerConfig, ReadOperation readOperation, @Nullable TimestampBound timestampBound, @Nullable PCollectionView<Transaction> transaction) {
        this.spannerConfig = spannerConfig;
        this.readOperation = readOperation;
        this.timestampBound = timestampBound;
        this.transaction = transaction;
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.spannerConfig;
    }

    @Override
    ReadOperation getReadOperation() {
        return this.readOperation;
    }

    @Override
    @Nullable
    TimestampBound getTimestampBound() {
        return this.timestampBound;
    }

    @Override
    @Nullable
    PCollectionView<Transaction> getTransaction() {
        return this.transaction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerIO.Read) {
            SpannerIO.Read that = (SpannerIO.Read)((Object)o);
            return this.spannerConfig.equals(that.getSpannerConfig()) && this.readOperation.equals(that.getReadOperation()) && (this.timestampBound == null ? that.getTimestampBound() == null : this.timestampBound.equals((Object)that.getTimestampBound())) && (this.transaction == null ? that.getTransaction() == null : this.transaction.equals(that.getTransaction()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.spannerConfig.hashCode();
        h *= 1000003;
        h ^= this.readOperation.hashCode();
        h *= 1000003;
        h ^= this.timestampBound == null ? 0 : this.timestampBound.hashCode();
        h *= 1000003;
        return h ^= this.transaction == null ? 0 : this.transaction.hashCode();
    }

    @Override
    SpannerIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SpannerIO.Read.Builder {
        private SpannerConfig spannerConfig;
        private ReadOperation readOperation;
        private TimestampBound timestampBound;
        private PCollectionView<Transaction> transaction;

        Builder() {
        }

        private Builder(SpannerIO.Read source) {
            this.spannerConfig = source.getSpannerConfig();
            this.readOperation = source.getReadOperation();
            this.timestampBound = source.getTimestampBound();
            this.transaction = source.getTransaction();
        }

        @Override
        SpannerIO.Read.Builder setSpannerConfig(SpannerConfig spannerConfig) {
            if (spannerConfig == null) {
                throw new NullPointerException("Null spannerConfig");
            }
            this.spannerConfig = spannerConfig;
            return this;
        }

        @Override
        SpannerIO.Read.Builder setReadOperation(ReadOperation readOperation) {
            if (readOperation == null) {
                throw new NullPointerException("Null readOperation");
            }
            this.readOperation = readOperation;
            return this;
        }

        @Override
        SpannerIO.Read.Builder setTimestampBound(@Nullable TimestampBound timestampBound) {
            this.timestampBound = timestampBound;
            return this;
        }

        @Override
        SpannerIO.Read.Builder setTransaction(@Nullable PCollectionView<Transaction> transaction) {
            this.transaction = transaction;
            return this;
        }

        @Override
        SpannerIO.Read build() {
            String missing = "";
            if (this.spannerConfig == null) {
                missing = missing + " spannerConfig";
            }
            if (this.readOperation == null) {
                missing = missing + " readOperation";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerIO_Read(this.spannerConfig, this.readOperation, this.timestampBound, this.transaction);
        }
    }
}

