/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Value;
import java.math.BigDecimal;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class MutationSizeEstimator {
    private MutationSizeEstimator() {
    }

    static @UnknownKeyFor @NonNull @Initialized long sizeOf(@UnknownKeyFor @NonNull @Initialized Mutation m) {
        if (m.getOperation() == Mutation.Op.DELETE) {
            return MutationSizeEstimator.sizeOf(m.getKeySet());
        }
        long result = 0L;
        block4: for (Value v : m.getValues()) {
            switch (v.getType().getCode()) {
                case ARRAY: {
                    result += MutationSizeEstimator.estimateArrayValue(v);
                    continue block4;
                }
                case STRUCT: {
                    throw new IllegalArgumentException("Structs are not supported in mutation.");
                }
            }
            result += MutationSizeEstimator.estimatePrimitiveValue(v);
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized long sizeOf(@UnknownKeyFor @NonNull @Initialized KeySet keySet) {
        long result = 0L;
        for (Key k : keySet.getKeys()) {
            result += MutationSizeEstimator.sizeOf(k);
        }
        for (KeyRange kr : keySet.getRanges()) {
            result += MutationSizeEstimator.sizeOf(kr);
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized long sizeOf(@UnknownKeyFor @NonNull @Initialized KeyRange kr) {
        return MutationSizeEstimator.sizeOf(kr.getStart()) + MutationSizeEstimator.sizeOf(kr.getEnd());
    }

    private static @UnknownKeyFor @NonNull @Initialized long sizeOf(@UnknownKeyFor @NonNull @Initialized Key k) {
        long result = 0L;
        for (Object part : k.getParts()) {
            if (part == null) continue;
            if (part instanceof Boolean) {
                ++result;
                continue;
            }
            if (part instanceof Long) {
                result += 8L;
                continue;
            }
            if (part instanceof Double) {
                result += 8L;
                continue;
            }
            if (part instanceof String) {
                result += (long)((String)part).length();
                continue;
            }
            if (part instanceof ByteArray) {
                result += (long)((ByteArray)part).length();
                continue;
            }
            if (part instanceof Timestamp) {
                result += 12L;
                continue;
            }
            if (!(part instanceof Date)) continue;
            result += 12L;
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized long sizeOf(@UnknownKeyFor @NonNull @Initialized MutationGroup group) {
        long result = 0L;
        for (Mutation m : group) {
            result += MutationSizeEstimator.sizeOf(m);
        }
        return result;
    }

    private static @UnknownKeyFor @NonNull @Initialized long estimatePrimitiveValue(@UnknownKeyFor @NonNull @Initialized Value v) {
        switch (v.getType().getCode()) {
            case BOOL: {
                return 1L;
            }
            case INT64: 
            case FLOAT64: {
                return 8L;
            }
            case DATE: 
            case TIMESTAMP: {
                return 12L;
            }
            case STRING: {
                return v.isNull() ? 0L : (long)v.getString().length();
            }
            case BYTES: {
                return v.isNull() ? 0L : (long)v.getBytes().length();
            }
            case NUMERIC: {
                return v.isNull() ? 0L : (long)v.getNumeric().toString().length();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + v.getType());
    }

    private static @UnknownKeyFor @NonNull @Initialized long estimateArrayValue(@UnknownKeyFor @NonNull @Initialized Value v) {
        if (v.isNull()) {
            return 0L;
        }
        switch (v.getType().getArrayElementType().getCode()) {
            case BOOL: {
                return v.getBoolArray().size();
            }
            case INT64: {
                return 8L * (long)v.getInt64Array().size();
            }
            case FLOAT64: {
                return 8L * (long)v.getFloat64Array().size();
            }
            case STRING: {
                long totalLength = 0L;
                for (String s : v.getStringArray()) {
                    if (s == null) continue;
                    totalLength += (long)s.length();
                }
                return totalLength;
            }
            case BYTES: {
                long totalLength = 0L;
                for (ByteArray bytes : v.getBytesArray()) {
                    if (bytes == null) continue;
                    totalLength += (long)bytes.length();
                }
                return totalLength;
            }
            case DATE: {
                return 12L * (long)v.getDateArray().size();
            }
            case TIMESTAMP: {
                return 12L * (long)v.getTimestampArray().size();
            }
            case NUMERIC: {
                long totalLength = 0L;
                for (BigDecimal n : v.getNumericArray()) {
                    if (n == null) continue;
                    totalLength += (long)n.toString().length();
                }
                return totalLength;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + v.getType());
    }
}

