/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TopicBacklogReaderImpl
implements TopicBacklogReader {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TopicBacklogReaderImpl.class);
    private final @UnknownKeyFor @NonNull @Initialized TopicStatsClient client;
    private final @UnknownKeyFor @NonNull @Initialized TopicPath topicPath;
    private final @UnknownKeyFor @NonNull @Initialized Partition partition;

    public TopicBacklogReaderImpl(@UnknownKeyFor @NonNull @Initialized TopicStatsClient client, @UnknownKeyFor @NonNull @Initialized TopicPath topicPath, @UnknownKeyFor @NonNull @Initialized Partition partition) {
        this.client = client;
        this.topicPath = topicPath;
        this.partition = partition;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse computeMessageStats(@UnknownKeyFor @NonNull @Initialized Offset offset) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        try {
            return (ComputeMessageStatsResponse)this.client.computeMessageStats(this.topicPath, this.partition, offset, Offset.of((long)Integer.MAX_VALUE)).get();
        }
        catch (ExecutionException e) {
            Throwable cause = (Throwable)Preconditions.checkNotNull((Object)e.getCause());
            throw ExtractStatus.toCanonical((Throwable)cause).underlying;
        }
        catch (InterruptedException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close topic stats client.", (Throwable)e);
        }
    }
}

