/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.cloud.pubsublite.proto.Subscription;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteRangeTracker;
import org.apache.beam.sdk.io.gcp.pubsublite.PerSubscriptionPartitionSdf;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartitionLoader;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartitionProcessorImpl;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

class SubscribeTransform
extends PTransform<PBegin, PCollection<SequencedMessage>> {
    private static final @UnknownKeyFor @NonNull @Initialized Duration MAX_SLEEP_TIME = Duration.standardMinutes((long)1L);
    private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions options;

    SubscribeTransform(@UnknownKeyFor @NonNull @Initialized SubscriberOptions options) {
        this.options = options;
    }

    private void checkSubscription(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        UncheckedApiPreconditions.checkArgument((boolean)subscriptionPartition.subscription().equals(this.options.subscriptionPath()));
    }

    private @UnknownKeyFor @NonNull @Initialized Subscriber newSubscriber(@UnknownKeyFor @NonNull @Initialized Partition partition, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage>> consumer) {
        try {
            return this.options.getSubscriberFactory(partition).newSubscriber(messages -> consumer.accept(messages.stream().map(message -> message.toProto()).collect(Collectors.toList())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized SubscriptionPartitionProcessor newPartitionProcessor(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        this.checkSubscription(subscriptionPartition);
        return new SubscriptionPartitionProcessorImpl(tracker, receiver, consumer -> this.newSubscriber(subscriptionPartition.partition(), (Consumer<List<SequencedMessage>>)consumer), this.options.flowControlSettings());
    }

    private @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> newRestrictionTracker(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @UnknownKeyFor @NonNull @Initialized OffsetRange initial) {
        this.checkSubscription(subscriptionPartition);
        return new OffsetByteRangeTracker(initial, this.options.getBacklogReader(subscriptionPartition.partition()), Stopwatch.createUnstarted(), MAX_SLEEP_TIME.multipliedBy(3L).dividedBy(4L), LongMath.saturatedMultiply((long)this.options.flowControlSettings().bytesOutstanding(), (long)10L));
    }

    private @UnknownKeyFor @NonNull @Initialized InitialOffsetReader newInitialOffsetReader(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return this.options.getInitialOffsetReader(subscriptionPartition.partition());
    }

    private @UnknownKeyFor @NonNull @Initialized Committer newCommitter(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return this.options.getCommitter(subscriptionPartition.partition());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @UnknownKeyFor @NonNull @Initialized TopicPath getTopicPath() {
        try (AdminClient admin = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(this.options.subscriptionPath().location().region()).build());){
            TopicPath topicPath = TopicPath.parse((String)((Subscription)admin.getSubscription(this.options.subscriptionPath()).get()).getTopic());
            return topicPath;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        PCollection subscriptionPartitions = this.options.partitions().isEmpty() ? (PCollection)input.apply((PTransform)new SubscriptionPartitionLoader(this.getTopicPath(), this.options.subscriptionPath())) : (PCollection)input.apply((PTransform)Create.of((Iterable)this.options.partitions().stream().map(partition -> SubscriptionPartition.of(this.options.subscriptionPath(), partition)).collect(Collectors.toList())));
        return (PCollection)subscriptionPartitions.apply((PTransform)ParDo.of((DoFn)new PerSubscriptionPartitionSdf(MAX_SLEEP_TIME, (SerializableFunction<SubscriptionPartition, InitialOffsetReader>)((SerializableFunction & Serializable)this::newInitialOffsetReader), (SerializableBiFunction<SubscriptionPartition, OffsetRange, RestrictionTracker<OffsetRange, OffsetByteProgress>>)((SerializableBiFunction & Serializable)this::newRestrictionTracker), this::newPartitionProcessor, (SerializableFunction<SubscriptionPartition, Committer>)((SerializableFunction & Serializable)this::newCommitter))));
    }
}

