/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.RowToPubsubMessage;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.io.InvalidSchemaException;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class PubsubSchemaIOProvider
implements SchemaIOProvider {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType VARCHAR = Schema.FieldType.STRING;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType TIMESTAMP = Schema.FieldType.DATETIME;

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "pubsub";
    }

    public @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        return Schema.builder().addNullableField("timestampAttributeKey", Schema.FieldType.STRING).addNullableField("deadLetterQueue", Schema.FieldType.STRING).addNullableField("format", Schema.FieldType.STRING).build();
    }

    public @UnknownKeyFor @NonNull @Initialized PubsubSchemaIO from(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
        this.validateConfigurationSchema(configuration);
        this.validateDlq((String)configuration.getValue("deadLetterQueue"));
        this.validateDataSchema(dataSchema);
        return new PubsubSchemaIO(location, configuration, dataSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDataSchema() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    private void validateDataSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (schema == null) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must not be null");
        }
        if (!PubsubSchemaIO.fieldPresent(schema, "event_timestamp", PubsubSchemaIOProvider.TIMESTAMP)) {
            throw new InvalidSchemaException("Unsupported schema specified for Pubsub source in CREATE TABLE.CREATE TABLE for Pubsub topic must include at least 'event_timestamp' field of type 'TIMESTAMP'");
        }
    }

    private void validateDlq(@UnknownKeyFor @NonNull @Initialized String deadLetterQueue) {
        if (deadLetterQueue != null && deadLetterQueue.isEmpty()) {
            throw new InvalidConfigurationException("Dead letter queue topic name is not specified");
        }
    }

    private void validateConfigurationSchema(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        if (!configuration.getSchema().equals((Object)this.configurationSchema())) {
            throw new InvalidConfigurationException("Configuration schema provided does not match expected");
        }
    }

    @AutoValue
    static abstract class Config
    implements Serializable {
        Config() {
        }

        abstract @Nullable @UnknownKeyFor @Initialized String getTimestampAttributeKey();

        abstract @Nullable @UnknownKeyFor @Initialized String getDeadLetterQueue();

        abstract @Nullable @UnknownKeyFor @Initialized String getFormat();

        @UnknownKeyFor @NonNull @Initialized boolean useDeadLetterQueue() {
            return this.getDeadLetterQueue() != null;
        }

        @UnknownKeyFor @NonNull @Initialized boolean useTimestampAttribute() {
            return this.getTimestampAttributeKey() != null;
        }

        @UnknownKeyFor @NonNull @Initialized PayloadFormat format() {
            return this.getFormat() == null ? PayloadFormat.JSON : PayloadFormat.valueOf(this.getFormat().toUpperCase());
        }
    }

    private static class PubsubSchemaIO
    implements SchemaIO,
    Serializable {
        protected final @UnknownKeyFor @NonNull @Initialized Schema dataSchema;
        protected final @UnknownKeyFor @NonNull @Initialized String location;
        protected final @UnknownKeyFor @NonNull @Initialized boolean useFlatSchema;
        protected final @UnknownKeyFor @NonNull @Initialized Config config;

        private PubsubSchemaIO(@UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized Row config, @UnknownKeyFor @NonNull @Initialized Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
            this.useFlatSchema = !this.definesAttributeAndPayload(dataSchema);
            this.config = (Config)new AutoValueSchema().fromRowFunction(TypeDescriptor.of(Config.class)).apply((Object)config);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema schema() {
            return this.dataSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
                    PCollectionTuple rowsWithDlq = (PCollectionTuple)((PCollection)begin.apply("ReadFromPubsub", (PTransform)this.readMessagesWithAttributes())).apply("PubsubMessageToRow", (PTransform)PubsubMessageToRow.builder().messageSchema(dataSchema).useDlq(config.useDeadLetterQueue()).useFlatSchema(useFlatSchema).payloadFormat(config.format()).build());
                    rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG).setRowSchema(dataSchema);
                    if (config.useDeadLetterQueue()) {
                        rowsWithDlq.get(PubsubMessageToRow.DLQ_TAG).apply((PTransform)this.writeMessagesToDlq());
                    }
                    return rowsWithDlq.get(PubsubMessageToRow.MAIN_TAG);
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized POutput> buildWriter() {
            if (!this.useFlatSchema) {
                throw new UnsupportedOperationException("Writing to a Pubsub topic is only supported for flattened schemas");
            }
            return new PTransform<PCollection<Row>, POutput>(){

                public @UnknownKeyFor @NonNull @Initialized POutput expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                    return ((PCollection)input.apply((PTransform)RowToPubsubMessage.of(config.useTimestampAttribute(), config.format(), dataSchema))).apply((PTransform)this.createPubsubMessageWrite());
                }
            };
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Read<@UnknownKeyFor @NonNull @Initialized PubsubMessage> readMessagesWithAttributes() {
            PubsubIO.Read<PubsubMessage> read = PubsubIO.readMessagesWithAttributes().fromTopic(this.location);
            return this.config.useTimestampAttribute() ? read.withTimestampAttribute(this.config.getTimestampAttributeKey()) : read;
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> createPubsubMessageWrite() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.location);
            if (this.config.useTimestampAttribute()) {
                write = write.withTimestampAttribute(this.config.getTimestampAttributeKey());
            }
            return write;
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> writeMessagesToDlq() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.config.getDeadLetterQueue());
            return this.config.useTimestampAttribute() ? write.withTimestampAttribute(this.config.getTimestampAttributeKey()) : write;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean definesAttributeAndPayload(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return PubsubSchemaIO.fieldPresent(schema, "attributes", Schema.FieldType.map((Schema.FieldType)VARCHAR.withNullable(false), (Schema.FieldType)VARCHAR)) && schema.hasField("payload") && Schema.TypeName.ROW.equals((Object)schema.getField("payload").getType().getTypeName());
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean fieldPresent(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType expectedType) {
            return schema.hasField(field) && expectedType.equivalent(schema.getField(field).getType(), Schema.EquivalenceNullablePolicy.IGNORE);
        }
    }

    public static enum PayloadFormat {
        JSON,
        AVRO;

    }
}

