/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFn;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigtableRowToBeamRowFlat
extends PTransform<PCollection<Row>, PCollection<org.apache.beam.sdk.values.Row>> {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping;

    public BigtableRowToBeamRowFlat(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping) {
        this.schema = schema;
        this.columnsMapping = columnsMapping;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBeamRowFn(this.schema, this.columnsMapping)));
    }

    private static class ToBeamRowFn
    extends BigtableRowToBeamRowFn {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping;

        public ToBeamRowFn(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping) {
            super(schema);
            this.columnsMapping = columnsMapping;
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row apply(@UnknownKeyFor @NonNull @Initialized Row bigtableRow) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)this.schema).withFieldValue("key", (Object)bigtableRow.getKey().toStringUtf8());
            bigtableRow.getFamiliesList().stream().filter(family -> this.columnsMapping.containsKey(family.getName())).forEach(family -> this.setFamily(rowBuilder, (Family)family));
            return rowBuilder.build();
        }

        private void setFamily(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Row.FieldValueBuilder rowBuilder, @UnknownKeyFor @NonNull @Initialized Family family) {
            Set<String> columns = this.columnsMapping.get(family.getName());
            if (columns == null) {
                throw new NullPointerException("Null column list at family " + family.getName());
            }
            family.getColumnsList().stream().filter(column -> columns.contains(column.getQualifier().toStringUtf8())).forEach(column -> this.setColumn(rowBuilder, (Column)column));
        }

        private void setColumn(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Row.FieldValueBuilder rowBuilder, @UnknownKeyFor @NonNull @Initialized Column column) {
            String columnName = column.getQualifier().toStringUtf8();
            Schema.TypeName type = this.schema.getField(columnName).getType().getTypeName();
            rowBuilder.withFieldValue(columnName, this.getCellValue(this.getLastCell(column.getCellsList()), type));
        }
    }
}

