/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.io.gcp.testing.TableContainer;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.junit.Assert;

@Internal
public class FakeDatasetService
implements BigQueryServices.DatasetService,
Serializable {
    static @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableContainer>> tables;
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> insertErrors = Maps.newHashMap();

    public static void setUp() {
        tables = HashBasedTable.create();
        FakeJobService.setUp();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (tableRef.getProjectId() == null) {
            throw new NullPointerException(String.format("tableRef is missing projectId: %s", tableRef));
        }
        return this.getTable(tableRef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table getTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            com.google.api.services.bigquery.model.Table table2 = (tableContainer = (TableContainer)dataset.get(tableRef.getTableId())) == null ? null : tableContainer.getTable();
            return table2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> getAllRows(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            return this.getTableContainer(projectId, datasetId, tableId).getRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getAllIds(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            return this.getTableContainer(projectId, datasetId, tableId).getIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized TableContainer getTableContainer(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", projectId, datasetId);
            }
            if ((tableContainer = (TableContainer)dataset.get(tableId)) == null) {
                this.throwNotFound("Tried to get a table %s:%s.%s, but no such table was set", projectId, datasetId, tableId);
            }
            return tableContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTable(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableRef);
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            dataset.remove(tableRef.getTableId());
        }
    }

    private static void validateWholeTableReference(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Pattern tableRegexp = Pattern.compile("[-\\w]{1,1024}");
        if (!tableRegexp.matcher(tableReference.getTableId()).matches()) {
            throw new IOException(String.format("invalid table ID %s. Table IDs must be alphanumeric (plus underscores) and must be at most 1024 characters long. Also, table decorators cannot be used.", tableReference.getTableId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table table) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableReference tableReference = table.getTableReference();
        FakeDatasetService.validateWholeTableReference(tableReference);
        Table<String, String, Map<String, TableContainer>> table2 = tables;
        synchronized (table2) {
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            dataset.computeIfAbsent(tableReference.getTableId(), k -> new TableContainer(table));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTableEmpty(@UnknownKeyFor @NonNull @Initialized TableReference tableRef) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Long numBytes = this.getTable(tableRef).getNumBytes();
        return numBytes == null || numBytes == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized Dataset getDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", projectId, datasetId);
            }
            return new Dataset().setDatasetReference(new DatasetReference().setDatasetId(datasetId).setProjectId(projectId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String location, @UnknownKeyFor @NonNull @Initialized String description, @UnknownKeyFor @NonNull @Initialized Long defaultTableExpirationMs) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            HashMap dataset = (HashMap)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                dataset = new HashMap();
                tables.put((Object)projectId, (Object)datasetId, dataset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            tables.remove((Object)projectId, (Object)datasetId);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long insertAll(@UnknownKeyFor @NonNull @Initialized TableReference ref, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rowList, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> insertIdList) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        ArrayList windowedRows = Lists.newArrayList();
        for (TableRow row : rowList) {
            windowedRows.add(FailsafeValueInSingleWindow.of((Object)row, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING, (Object)row));
        }
        return this.insertAll(ref, windowedRows, insertIdList, InsertRetryPolicy.alwaysRetry(), null, null, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized long insertAll(@UnknownKeyFor @NonNull @Initialized TableReference ref, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FailsafeValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow>> rowList, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> insertIdList, @UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> failedInserts, @UnknownKeyFor @NonNull @Initialized ErrorContainer<T> errorContainer, @UnknownKeyFor @NonNull @Initialized boolean skipInvalidRows, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean ignoreInsertIds) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Map<TableRow, List<TableDataInsertAllResponse.InsertErrors>> insertErrors = this.getInsertErrors();
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            if (ignoreInsertIds) {
                insertIdList = null;
            }
            if (insertIdList != null) {
                Assert.assertEquals((long)rowList.size(), (long)insertIdList.size());
            }
            long dataSize = 0L;
            TableContainer tableContainer = this.getTableContainer(ref.getProjectId(), ref.getDatasetId(), BigQueryHelpers.stripPartitionDecorator(ref.getTableId()));
            for (int i = 0; i < rowList.size(); ++i) {
                TableRow row = (TableRow)rowList.get(i).getValue();
                List<TableDataInsertAllResponse.InsertErrors> allErrors = insertErrors.get(row);
                boolean shouldInsert = true;
                if (allErrors != null) {
                    for (TableDataInsertAllResponse.InsertErrors errors : allErrors) {
                        if (retryPolicy.shouldRetry(new InsertRetryPolicy.Context(errors))) continue;
                        shouldInsert = false;
                    }
                }
                if (shouldInsert) {
                    if (insertIdList == null) {
                        dataSize += tableContainer.addRow(row, null);
                        continue;
                    }
                    dataSize += tableContainer.addRow(row, insertIdList.get(i));
                    continue;
                }
                errorContainer.add(failedInserts, allErrors.get(allErrors.size() - 1), ref, rowList.get(i));
            }
            return dataSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table patchTableDescription(@UnknownKeyFor @NonNull @Initialized TableReference tableReference, @Nullable @UnknownKeyFor @Initialized String tableDescription) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            TableContainer tableContainer = this.getTableContainer(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
            tableContainer.getTable().setDescription(tableDescription);
            return tableContainer.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOnInsert(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors>> insertErrors) {
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            for (Map.Entry<TableRow, List<TableDataInsertAllResponse.InsertErrors>> entry : insertErrors.entrySet()) {
                ArrayList errorStrings = Lists.newArrayList();
                for (TableDataInsertAllResponse.InsertErrors errors : entry.getValue()) {
                    errorStrings.add(BigQueryHelpers.toJsonString(errors));
                }
                this.insertErrors.put(BigQueryHelpers.toJsonString(entry.getKey()), errorStrings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse.InsertErrors>> getInsertErrors() {
        HashMap parsedInsertErrors = Maps.newHashMap();
        Table<String, String, Map<String, TableContainer>> table = tables;
        synchronized (table) {
            for (Map.Entry<String, List<String>> entry : this.insertErrors.entrySet()) {
                TableRow tableRow = BigQueryHelpers.fromJsonString(entry.getKey(), TableRow.class);
                ArrayList allErrors = Lists.newArrayList();
                for (String errorsString : entry.getValue()) {
                    allErrors.add(BigQueryHelpers.fromJsonString(errorsString, TableDataInsertAllResponse.InsertErrors.class));
                }
                parsedInsertErrors.put(tableRow, allErrors);
            }
        }
        return parsedInsertErrors;
    }

    void throwNotFound(@UnknownKeyFor @NonNull @Initialized String format, Object ... args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new IOException(String.format(format, args), (Throwable)new HttpResponseException.Builder(404, String.format(format, args), new HttpHeaders()).build());
    }
}

