/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.DateTime;
import com.google.auto.value.AutoValue;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubClient_IncomingMessage;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubClient_OutgoingMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class PubsubClient
implements Closeable {
    private static @Nullable @UnknownKeyFor @Initialized Long asMsSinceEpoch(@Nullable @UnknownKeyFor @Initialized String timestamp) {
        if (Strings.isNullOrEmpty((String)timestamp)) {
            return null;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (IllegalArgumentException e1) {
            return DateTime.parseRfc3339((String)timestamp).getValue();
        }
    }

    protected static @UnknownKeyFor @NonNull @Initialized long extractTimestamp(@Nullable @UnknownKeyFor @Initialized String timestampAttribute, @Nullable @UnknownKeyFor @Initialized String pubsubTimestamp, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributes) {
        Long timestampMsSinceEpoch;
        if (Strings.isNullOrEmpty((String)timestampAttribute)) {
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(pubsubTimestamp);
            Preconditions.checkArgument((timestampMsSinceEpoch != null ? 1 : 0) != 0, (String)"Cannot interpret PubSub publish timestamp: %s", (Object)pubsubTimestamp);
        } else {
            String value = attributes == null ? null : attributes.get(timestampAttribute);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"PubSub message is missing a value for timestamp attribute %s", (Object)timestampAttribute);
            timestampMsSinceEpoch = PubsubClient.asMsSinceEpoch(value);
            Preconditions.checkArgument((timestampMsSinceEpoch != null ? 1 : 0) != 0, (String)"Cannot interpret value of attribute %s as timestamp: %s", (Object)timestampAttribute, (Object)value);
        }
        return timestampMsSinceEpoch;
    }

    public static @UnknownKeyFor @NonNull @Initialized ProjectPath projectPathFromPath(@UnknownKeyFor @NonNull @Initialized String path) {
        return new ProjectPath(path);
    }

    public static @UnknownKeyFor @NonNull @Initialized ProjectPath projectPathFromId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return new ProjectPath(String.format("projects/%s", projectId));
    }

    public static @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPathFromPath(@UnknownKeyFor @NonNull @Initialized String path) {
        return new SubscriptionPath(path);
    }

    public static @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPathFromName(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String subscriptionName) {
        return new SubscriptionPath(String.format("projects/%s/subscriptions/%s", projectId, subscriptionName));
    }

    public static @UnknownKeyFor @NonNull @Initialized TopicPath topicPathFromPath(@UnknownKeyFor @NonNull @Initialized String path) {
        return new TopicPath(path);
    }

    public static @UnknownKeyFor @NonNull @Initialized TopicPath topicPathFromName(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String topicName) {
        return new TopicPath(String.format("projects/%s/topics/%s", projectId, topicName));
    }

    public abstract @UnknownKeyFor @NonNull @Initialized int publish(@UnknownKeyFor @NonNull @Initialized TopicPath var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OutgoingMessage> var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IncomingMessage> pull(@UnknownKeyFor @NonNull @Initialized long var1, @UnknownKeyFor @NonNull @Initialized SubscriptionPath var3, @UnknownKeyFor @NonNull @Initialized int var4, @UnknownKeyFor @NonNull @Initialized boolean var5) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract void acknowledge(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract void modifyAckDeadline(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var2, @UnknownKeyFor @NonNull @Initialized int var3) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract void createTopic(@UnknownKeyFor @NonNull @Initialized TopicPath var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract void deleteTopic(@UnknownKeyFor @NonNull @Initialized TopicPath var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TopicPath> listTopics(@UnknownKeyFor @NonNull @Initialized ProjectPath var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract void createSubscription(@UnknownKeyFor @NonNull @Initialized TopicPath var1, @UnknownKeyFor @NonNull @Initialized SubscriptionPath var2, @UnknownKeyFor @NonNull @Initialized int var3) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public @UnknownKeyFor @NonNull @Initialized SubscriptionPath createRandomSubscription(@UnknownKeyFor @NonNull @Initialized ProjectPath project, @UnknownKeyFor @NonNull @Initialized TopicPath topic, @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String subscriptionName = topic.getName() + "_beam_" + ThreadLocalRandom.current().nextLong();
        SubscriptionPath subscription = PubsubClient.subscriptionPathFromName(project.getId(), subscriptionName);
        this.createSubscription(topic, subscription, ackDeadlineSeconds);
        return subscription;
    }

    public abstract void deleteSubscription(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SubscriptionPath> listSubscriptions(@UnknownKeyFor @NonNull @Initialized ProjectPath var1, @UnknownKeyFor @NonNull @Initialized TopicPath var2) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized int ackDeadlineSeconds(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

    public abstract @UnknownKeyFor @NonNull @Initialized boolean isEOF();

    @AutoValue
    static abstract class IncomingMessage
    implements Serializable {
        IncomingMessage() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage message();

        public abstract @UnknownKeyFor @NonNull @Initialized long timestampMsSinceEpoch();

        public abstract @UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch();

        public abstract @UnknownKeyFor @NonNull @Initialized String ackId();

        public abstract @UnknownKeyFor @NonNull @Initialized String recordId();

        public static @UnknownKeyFor @NonNull @Initialized IncomingMessage of(@UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage message, @UnknownKeyFor @NonNull @Initialized long timestampMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized long requestTimeMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized String ackId, @UnknownKeyFor @NonNull @Initialized String recordId) {
            return new AutoValue_PubsubClient_IncomingMessage(message, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId);
        }
    }

    @AutoValue
    public static abstract class OutgoingMessage
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage message();

        public abstract @UnknownKeyFor @NonNull @Initialized long timestampMsSinceEpoch();

        public abstract @Nullable @UnknownKeyFor @Initialized String recordId();

        public static @UnknownKeyFor @NonNull @Initialized OutgoingMessage of(@UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage message, @UnknownKeyFor @NonNull @Initialized long timestampMsSinceEpoch, @Nullable @UnknownKeyFor @Initialized String recordId) {
            return new AutoValue_PubsubClient_OutgoingMessage(message, timestampMsSinceEpoch, recordId);
        }

        public static @UnknownKeyFor @NonNull @Initialized OutgoingMessage of(@UnknownKeyFor @NonNull @Initialized PubsubMessage message, @UnknownKeyFor @NonNull @Initialized long timestampMsSinceEpoch, @Nullable @UnknownKeyFor @Initialized String recordId) {
            PubsubMessage.Builder builder = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])message.getPayload()));
            if (message.getAttributeMap() != null) {
                builder.putAllAttributes(message.getAttributeMap());
            }
            return OutgoingMessage.of(builder.build(), timestampMsSinceEpoch, recordId);
        }
    }

    public static class TopicPath
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized String path;

        TopicPath(@UnknownKeyFor @NonNull @Initialized String path) {
            this.path = path;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPath() {
            return this.path;
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return (String)splits.get(3);
        }

        public @UnknownKeyFor @NonNull @Initialized String getV1Beta1Path() {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)this.path);
            Preconditions.checkState((splits.size() == 4 ? 1 : 0) != 0, (String)"Malformed topic path %s", (Object)this.path);
            return String.format("/topics/%s/%s", splits.get(1), splits.get(3));
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicPath topicPath = (TopicPath)o;
            return this.path.equals(topicPath.path);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.path.hashCode();
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.path;
        }
    }

    public static class SubscriptionPath
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;
        private final @UnknownKeyFor @NonNull @Initialized String subscriptionName;

        SubscriptionPath(@UnknownKeyFor @NonNull @Initialized String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkState((splits.size() == 4 && "projects".equals(splits.get(0)) && "subscriptions".equals(splits.get(2)) ? 1 : 0) != 0, (String)"Malformed subscription path %s: must be of the form \"projects/\" + <project id> + \"subscriptions\"", (Object)path);
            this.projectId = (String)splits.get(1);
            this.subscriptionName = (String)splits.get(3);
        }

        public @UnknownKeyFor @NonNull @Initialized String getPath() {
            return String.format("projects/%s/subscriptions/%s", this.projectId, this.subscriptionName);
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.subscriptionName;
        }

        public @UnknownKeyFor @NonNull @Initialized String getV1Beta1Path() {
            return String.format("/subscriptions/%s/%s", this.projectId, this.subscriptionName);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionPath that = (SubscriptionPath)o;
            return this.subscriptionName.equals(that.subscriptionName) && this.projectId.equals(that.projectId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.projectId, this.subscriptionName});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.getPath();
        }
    }

    public static class ProjectPath
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized String projectId;

        ProjectPath(@UnknownKeyFor @NonNull @Initialized String path) {
            List splits = Splitter.on((char)'/').splitToList((CharSequence)path);
            Preconditions.checkArgument((splits.size() == 2 && "projects".equals(splits.get(0)) ? 1 : 0) != 0, (String)"Malformed project path \"%s\": must be of the form \"projects/\" + <project id>", (Object)path);
            this.projectId = (String)splits.get(1);
        }

        public @UnknownKeyFor @NonNull @Initialized String getPath() {
            return String.format("projects/%s", this.projectId);
        }

        public @UnknownKeyFor @NonNull @Initialized String getId() {
            return this.projectId;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectPath that = (ProjectPath)o;
            return this.projectId.equals(that.projectId);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.projectId.hashCode();
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.getPath();
        }
    }

    public static interface PubsubClientFactory
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized PubsubClient newClient(@Nullable @UnknownKeyFor @Initialized String var1, @Nullable @UnknownKeyFor @Initialized String var2, @UnknownKeyFor @NonNull @Initialized PubsubOptions var3) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public @UnknownKeyFor @NonNull @Initialized String getKind();
    }
}

