/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFn;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigtableRowToBeamRow
extends PTransform<PCollection<Row>, PCollection<org.apache.beam.sdk.values.Row>>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;

    public BigtableRowToBeamRow(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        this.schema = schema;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBeamRowFn(this.schema)));
    }

    private static class ToBeamRowFn
    extends BigtableRowToBeamRowFn {
        ToBeamRowFn(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            super(schema);
        }

        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row apply(@UnknownKeyFor @NonNull @Initialized Row bigtableRow) {
            return this.bigtableRowToBeamRow(bigtableRow);
        }

        private @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row cellToRow(@UnknownKeyFor @NonNull @Initialized Cell cell, @UnknownKeyFor @NonNull @Initialized Schema cellSchema) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)cellSchema).withFieldValue("val", this.getCellValue(cell, cellSchema.getField("val").getType().getTypeName()));
            if (cellSchema.hasField("timestampMicros")) {
                rowBuilder.withFieldValue("timestampMicros", (Object)cell.getTimestampMicros());
            }
            if (cellSchema.hasField("labels")) {
                rowBuilder.withFieldValue("labels", (Object)cell.getLabelsList());
            }
            return rowBuilder.build();
        }

        private @UnknownKeyFor @NonNull @Initialized Object columnToRow(@UnknownKeyFor @NonNull @Initialized Column column, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            String columnName = column.getQualifier().toStringUtf8();
            Schema.FieldType columnType = schema.getField(columnName).getType();
            List cells = column.getCellsList();
            switch (columnType.getTypeName()) {
                case ARRAY: {
                    Schema.FieldType collectionElementType = columnType.getCollectionElementType();
                    if (collectionElementType != null) {
                        return cells.stream().map(cell -> this.getCellValue((Cell)cell, collectionElementType.getTypeName())).collect(Collectors.toList());
                    }
                    throw new NullPointerException("Null collectionElementType at column " + columnName);
                }
                case ROW: {
                    Schema rowSchema = columnType.getRowSchema();
                    if (rowSchema == null) {
                        throw new NullPointerException("Null row schema at column " + columnName);
                    }
                    return this.cellToRow(this.getLastCell(cells), rowSchema);
                }
            }
            return this.getCellValue(this.getLastCell(cells), columnType.getTypeName());
        }

        private @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row familyToRow(@UnknownKeyFor @NonNull @Initialized Family family, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            Map<String, Object> columns = family.getColumnsList().stream().filter(column -> schema.hasField(column.getQualifier().toStringUtf8())).map(column -> {
                String columnName = column.getQualifier().toStringUtf8();
                return KV.of((Object)columnName, (Object)this.columnToRow((Column)column, schema));
            }).collect(Collectors.toMap(KV::getKey, kv -> {
                Object value = kv.getValue();
                if (value == null) {
                    throw new NullPointerException("Null value at column " + (String)kv.getKey());
                }
                return value;
            }));
            return org.apache.beam.sdk.values.Row.withSchema((Schema)schema).withFieldValues(columns).build();
        }

        private @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row bigtableRowToBeamRow(@UnknownKeyFor @NonNull @Initialized Row bigtableRow) {
            Row.FieldValueBuilder rowBuilder = org.apache.beam.sdk.values.Row.withSchema((Schema)this.schema).withFieldValue("key", (Object)bigtableRow.getKey().toStringUtf8());
            bigtableRow.getFamiliesList().stream().filter(family -> this.schema.hasField(family.getName())).forEach(family -> {
                Schema familySchema = this.schema.getField(family.getName()).getType().getRowSchema();
                if (familySchema == null) {
                    throw new NullPointerException("Null family schema at family " + family.getName());
                }
                rowBuilder.withFieldValue(family.getName(), (Object)this.familyToRow((Family)family, familySchema));
            });
            return rowBuilder.build();
        }
    }
}

