/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TableDestinationCoder
extends AtomicCoder<TableDestination> {
    private static final @UnknownKeyFor @NonNull @Initialized TableDestinationCoder INSTANCE = new TableDestinationCoder();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> tableSpecCoder = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> tableDescriptionCoder = NullableCoder.of((Coder)StringUtf8Coder.of());

    private TableDestinationCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized TableDestinationCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized TableDestination value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null value");
        }
        tableSpecCoder.encode((Object)value.getTableSpec(), outStream);
        tableDescriptionCoder.encode((Object)value.getTableDescription(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized TableDestination decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String tableSpec = (String)tableSpecCoder.decode(inStream);
        String tableDescription = (String)tableDescriptionCoder.decode(inStream);
        return new TableDestination(tableSpec, tableDescription);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
    }
}

