/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryQueryHelper {
    private static final @UnknownKeyFor @NonNull @Initialized Integer JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryQueryHelper.class);

    BigQueryQueryHelper() {
    }

    public static @UnknownKeyFor @NonNull @Initialized JobStatistics dryRunQueryIfNeeded(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized BigQueryOptions options, @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized JobStatistics> dryRunJobStats, @UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql, @Nullable @UnknownKeyFor @Initialized String location) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (dryRunJobStats.get() == null) {
            JobStatistics jobStatistics = bqServices.getJobService(options).dryRunQuery(options.getProject(), BigQueryQueryHelper.createBasicQueryConfig(query, flattenResults, useLegacySql), location);
            dryRunJobStats.compareAndSet(null, jobStatistics);
        }
        return dryRunJobStats.get();
    }

    public static @UnknownKeyFor @NonNull @Initialized TableReference executeQuery(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized BigQueryOptions options, @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized JobStatistics> dryRunJobStats, @UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.QueryPriority priority, @Nullable @UnknownKeyFor @Initialized String location, @Nullable @UnknownKeyFor @Initialized String queryTempDatasetId, @Nullable @UnknownKeyFor @Initialized String kmsKey) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        boolean beamToCreateTempDataset;
        List referencedTables;
        String effectiveLocation = location;
        BigQueryServices.DatasetService tableService = bqServices.getDatasetService(options);
        if (effectiveLocation == null && (referencedTables = BigQueryQueryHelper.dryRunQueryIfNeeded(bqServices, options, dryRunJobStats, query, flattenResults, useLegacySql, location).getQuery().getReferencedTables()) != null && !referencedTables.isEmpty()) {
            TableReference referencedTable = (TableReference)referencedTables.get(0);
            effectiveLocation = tableService.getTable(referencedTable).getLocation();
        }
        String queryJobId = BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), stepUuid, BigQueryResourceNaming.JobType.QUERY);
        Optional<String> queryTempDatasetOpt = Optional.ofNullable(queryTempDatasetId);
        TableReference queryResultTable = BigQueryResourceNaming.createTempTableReference(options.getProject(), queryJobId, queryTempDatasetOpt);
        boolean bl = beamToCreateTempDataset = !queryTempDatasetOpt.isPresent();
        if (beamToCreateTempDataset) {
            LOG.info("Creating temporary dataset {} for query results", (Object)queryResultTable.getDatasetId());
            tableService.createDataset(queryResultTable.getProjectId(), queryResultTable.getDatasetId(), effectiveLocation, "Temporary tables for query results of job " + options.getJobName(), TimeUnit.DAYS.toMillis(1L));
        } else {
            Table destTable = tableService.getTable(queryResultTable);
            Preconditions.checkArgument((destTable == null ? 1 : 0) != 0, (String)"Refusing to write on existing table {} in the specified temp dataset {}", (Object)queryResultTable.getTableId(), (Object)queryResultTable.getDatasetId());
        }
        LOG.info("Exporting query results into temporary table {} using job {}", (Object)queryResultTable, (Object)queryJobId);
        JobReference jobReference = new JobReference().setProjectId(options.getProject()).setLocation(effectiveLocation).setJobId(queryJobId);
        JobConfigurationQuery queryConfiguration = BigQueryQueryHelper.createBasicQueryConfig(query, flattenResults, useLegacySql).setAllowLargeResults(Boolean.valueOf(true)).setDestinationTable(queryResultTable).setCreateDisposition("CREATE_IF_NEEDED").setWriteDisposition("WRITE_TRUNCATE").setPriority(priority.name());
        if (kmsKey != null) {
            queryConfiguration.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
        }
        BigQueryServices.JobService jobService = bqServices.getJobService(options);
        jobService.startQueryJob(jobReference, queryConfiguration);
        Job job = jobService.pollJob(jobReference, JOB_POLL_MAX_RETRIES);
        if (BigQueryHelpers.parseStatus(job) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Query job %s failed, status: %s", queryJobId, BigQueryHelpers.statusToPrettyString(job.getStatus())));
        }
        LOG.info("Query job {} completed", (Object)queryJobId);
        return queryResultTable;
    }

    private static @UnknownKeyFor @NonNull @Initialized JobConfigurationQuery createBasicQueryConfig(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql) {
        return new JobConfigurationQuery().setQuery(query).setFlattenResults(flattenResults).setUseLegacySql(useLegacySql);
    }
}

