/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.Uuid;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class UuidDeduplicationTransform
extends PTransform<PCollection<SequencedMessage>, PCollection<SequencedMessage>> {
    private final @UnknownKeyFor @NonNull @Initialized UuidDeduplicationOptions options;

    UuidDeduplicationTransform(@UnknownKeyFor @NonNull @Initialized UuidDeduplicationOptions options) {
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> input) {
        ProcessFunction & Serializable mapWithKeys = (ProcessFunction & Serializable)message -> KV.of((Object)this.options.uuidExtractor().apply((SequencedMessage)message), (Object)message);
        PCollection uuidMapped = (PCollection)input.apply("MapUuids", (PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<KV<Uuid, SequencedMessage>>(){}).via((ProcessFunction)mapWithKeys));
        PCollection unique = (PCollection)uuidMapped.apply("Deduplicate", this.options.deduplicate());
        return (PCollection)unique.apply("StripUuids", (PTransform)Values.create());
    }
}

