/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import io.grpc.StatusException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class SubscriberOptions
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 269598118L;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    abstract @UnknownKeyFor @NonNull @Initialized SubscriptionPath subscriptionPath();

    abstract @UnknownKeyFor @NonNull @Initialized FlowControlSettings flowControlSettings();

    abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Partition> partitions();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized SubscriberServiceGrpc.SubscriberServiceStub> subscriberStubSupplier();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CursorServiceGrpc.CursorServiceStub> committerStubSupplier();

    abstract @Nullable @UnknownKeyFor @Initialized SubscriberFactory subscriberFactory();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Committer> committerSupplier();

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        AutoValue_SubscriberOptions.Builder builder = new AutoValue_SubscriberOptions.Builder();
        return ((Builder)builder).setPartitions((Set<Partition>)ImmutableSet.of());
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Partition, @UnknownKeyFor @NonNull @Initialized SubscriberFactory> getSubscriberFactories() {
        ImmutableMap.Builder factories = ImmutableMap.builder();
        for (Partition partition : this.partitions()) {
            factories.put((Object)partition, (Object)((SubscriberFactory)Optional.fromNullable((Object)this.subscriberFactory()).or(consumer -> {
                SubscriberBuilder.Builder builder = SubscriberBuilder.newBuilder();
                builder.setMessageConsumer(consumer);
                builder.setSubscriptionPath(this.subscriptionPath());
                builder.setPartition(partition);
                builder.setContext(PubsubContext.of((PubsubContext.Framework)FRAMEWORK));
                if (this.subscriberStubSupplier() != null) {
                    builder.setSubscriberServiceStub(this.subscriberStubSupplier().get());
                }
                return builder.build();
            })));
        }
        return factories.build();
    }

    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Partition, @UnknownKeyFor @NonNull @Initialized Committer> getCommitters() throws @UnknownKeyFor @NonNull @Initialized StatusException {
        ImmutableMap.Builder committers = ImmutableMap.builder();
        for (Partition partition : this.partitions()) {
            if (this.committerSupplier() != null) {
                committers.put((Object)partition, (Object)this.committerSupplier().get());
                continue;
            }
            CommitterBuilder.Builder builder = CommitterBuilder.newBuilder();
            builder.setSubscriptionPath(this.subscriptionPath());
            builder.setPartition(partition);
            if (this.committerStubSupplier() != null) {
                builder.setCursorStub(this.committerStubSupplier().get());
            }
            committers.put((Object)partition, (Object)builder.build());
        }
        return committers.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriptionPath(@UnknownKeyFor @NonNull @Initialized SubscriptionPath var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Partition> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFlowControlSettings(@UnknownKeyFor @NonNull @Initialized FlowControlSettings var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriberStubSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized SubscriberServiceGrpc.SubscriberServiceStub> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitterStubSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CursorServiceGrpc.CursorServiceStub> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriberFactory(@UnknownKeyFor @NonNull @Initialized SubscriberFactory var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitterSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Committer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized SubscriberOptions autoBuild();

        public @UnknownKeyFor @NonNull @Initialized SubscriberOptions build() throws @UnknownKeyFor @NonNull @Initialized StatusException {
            SubscriberOptions built = this.autoBuild();
            if (!built.partitions().isEmpty()) {
                return built;
            }
            int partitionCount = PartitionLookupUtils.numPartitions((SubscriptionPath)built.subscriptionPath());
            Builder builder = built.toBuilder();
            ImmutableSet.Builder partitions = ImmutableSet.builder();
            for (int i = 0; i < partitionCount; ++i) {
                partitions.add((Object)Partition.of((long)i));
            }
            return builder.setPartitions((Set<Partition>)partitions.build()).autoBuild();
        }
    }
}

