/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.internal.BufferingPullSubscriber;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.PullSubscriber;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SeekRequest;
import io.grpc.StatusException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetCheckpointMark;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteUnboundedReader;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.TranslatingPullSubscriber;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class PubsubLiteUnboundedSource
extends UnboundedSource<com.google.cloud.pubsublite.proto.SequencedMessage, OffsetCheckpointMark> {
    private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions subscriberOptions;

    PubsubLiteUnboundedSource(@UnknownKeyFor @NonNull @Initialized SubscriberOptions options) {
        this.subscriberOptions = options;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized com.google.cloud.pubsublite.proto.SequencedMessage, @UnknownKeyFor @NonNull @Initialized OffsetCheckpointMark>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List partitionSubset : Iterables.partition(this.subscriberOptions.partitions(), (int)desiredNumSplits)) {
            if (partitionSubset.isEmpty()) continue;
            try {
                builder.add((Object)new PubsubLiteUnboundedSource(this.subscriberOptions.toBuilder().setPartitions((Set<Partition>)ImmutableSet.copyOf((Collection)partitionSubset)).build()));
            }
            catch (StatusException e) {
                throw e.getStatus().asRuntimeException();
            }
        }
        return builder.build();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized com.google.cloud.pubsublite.proto.SequencedMessage> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized OffsetCheckpointMark checkpointMark) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            Map<Partition, SubscriberFactory> subscriberFactories = this.subscriberOptions.getSubscriberFactories();
            Map<Partition, Committer> committers = this.subscriberOptions.getCommitters();
            ImmutableMap.Builder statesBuilder = ImmutableMap.builder();
            for (Partition partition : subscriberFactories.keySet()) {
                Preconditions.checkState((boolean)committers.containsKey(partition));
                PubsubLiteUnboundedReader.SubscriberState state = new PubsubLiteUnboundedReader.SubscriberState();
                state.committer = committers.get(partition);
                if (checkpointMark != null && checkpointMark.partitionOffsetMap.containsKey(partition)) {
                    Offset checkpointed = checkpointMark.partitionOffsetMap.get(partition);
                    state.lastDelivered = Optional.of(checkpointed);
                    state.subscriber = new TranslatingPullSubscriber((PullSubscriber<SequencedMessage>)new BufferingPullSubscriber(subscriberFactories.get(partition), this.subscriberOptions.flowControlSettings(), SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(checkpointed.value())).build()));
                } else {
                    state.subscriber = new TranslatingPullSubscriber((PullSubscriber<SequencedMessage>)new BufferingPullSubscriber(subscriberFactories.get(partition), this.subscriberOptions.flowControlSettings()));
                }
                statesBuilder.put((Object)partition, (Object)state);
            }
            return new PubsubLiteUnboundedReader(this, (Map<Partition, PubsubLiteUnboundedReader.SubscriberState>)statesBuilder.build());
        }
        catch (StatusException e) {
            throw new IOException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized OffsetCheckpointMark> getCheckpointMarkCoder() {
        return OffsetCheckpointMark.getCoder();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized com.google.cloud.pubsublite.proto.SequencedMessage> getOutputCoder() {
        return ProtoCoder.of(com.google.cloud.pubsublite.proto.SequencedMessage.class);
    }
}

