/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class BigQueryTableSource<@UnknownKeyFor T>
extends BigQuerySourceBase<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryTableSource.class);
    private final @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Long> tableSizeBytes;

    static <T> @UnknownKeyFor @NonNull @Initialized BigQueryTableSource<T> create(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        return new BigQueryTableSource<T>(stepUuid, tableDef, bqServices, coder, parseFn, useAvroLogicalTypes);
    }

    private BigQueryTableSource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized BigQueryTableSourceDef tableDef, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized boolean useAvroLogicalTypes) {
        super(stepUuid, bqServices, coder, parseFn, useAvroLogicalTypes);
        this.tableDef = tableDef;
        this.tableSizeBytes = new AtomicReference();
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TableReference getTableToExtract(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.tableDef.getTableReference(bqOptions);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.tableSizeBytes.get() == null) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            TableReference tableRef = this.tableDef.getTableReference(bqOptions);
            Table table = this.bqServices.getDatasetService(bqOptions).getTable(tableRef);
            Long numBytes = table.getNumBytes();
            if (table.getStreamingBuffer() != null && table.getStreamingBuffer().getEstimatedBytes() != null) {
                numBytes = numBytes + table.getStreamingBuffer().getEstimatedBytes().longValue();
            }
            this.tableSizeBytes.compareAndSet(null, numBytes);
        }
        return this.tableSizeBytes.get();
    }

    @Override
    protected void cleanupTempResource(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", this.tableDef.getJsonTable()));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }
}

