/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerReadFn;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteGroupFn;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).build();
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).build();
    }

    @Experimental
    public static CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).build();
    }

    private SpannerIO() {
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, PDone> {
        private final Write spec;

        public WriteGrouped(Write spec) {
            this.spec = spec;
        }

        public PDone expand(PCollection<MutationGroup> input) {
            input.apply("Write mutations to Cloud Spanner", (PTransform)ParDo.of((DoFn)new SpannerWriteGroupFn(this.spec)));
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, PDone> {
        abstract SpannerConfig getSpannerConfig();

        abstract long getBatchSizeBytes();

        abstract Builder toBuilder();

        public Write withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Write withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Write withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        Write withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public Write withBatchSizeBytes(long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public PDone expand(PCollection<Mutation> input) {
            this.getSpannerConfig().validate();
            ((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)ParDo.of((DoFn)new SpannerWriteGroupFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Batch Size in Bytes"));
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setBatchSizeBytes(long var1);

            abstract Write build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class CreateTransaction
    extends PTransform<PBegin, PCollectionView<Transaction>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public PCollectionView<Transaction> expand(PBegin input) {
            this.getSpannerConfig().validate();
            return (PCollectionView)((PCollection)((PCollection)input.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public CreateTransaction withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public CreateTransaction withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public CreateTransaction withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public CreateTransaction withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public CreateTransaction withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public CreateTransaction withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public CreateTransaction withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        CreateTransaction withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public CreateTransaction withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public static abstract class Builder {
            public abstract Builder setSpannerConfig(SpannerConfig var1);

            public abstract Builder setTimestampBound(TimestampBound var1);

            public abstract CreateTransaction build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        abstract ReadOperation getReadOperation();

        @Nullable
        abstract TimestampBound getTimestampBound();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        abstract Builder toBuilder();

        public Read withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Read withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Read withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        Read withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public Read withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public Read withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public Read withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public Read withTable(String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public Read withReadOperation(ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public Read withColumns(List<String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public Read withQuery(Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public Read withQuery(String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public Read withKeySet(KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public Read withIndex(String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public PCollection<Struct> expand(PBegin input) {
            PCollectionView transaction;
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            if ((transaction = this.getTransaction()) == null && this.getTimestampBound() != null) {
                transaction = (PCollectionView)input.apply((PTransform)SpannerIO.createTransaction().withTimestampBound(this.getTimestampBound()).withSpannerConfig(this.getSpannerConfig()));
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTransaction(transaction);
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setReadOperation(ReadOperation var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Read build();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        @Nullable
        abstract PCollectionView<Transaction> getTransaction();

        abstract Builder toBuilder();

        public ReadAll withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public ReadAll withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public ReadAll withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public ReadAll withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public ReadAll withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public ReadAll withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public ReadAll withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        ReadAll withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public ReadAll withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public PCollection<Struct> expand(PCollection<ReadOperation> input) {
            List sideInputs = this.getTransaction() == null ? Collections.emptyList() : Collections.singletonList(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Reshuffle.viaRandomKey())).apply("Execute queries", (PTransform)ParDo.of((DoFn)new NaiveSpannerReadFn(this.getSpannerConfig(), this.getTransaction())).withSideInputs(sideInputs));
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract ReadAll build();
        }
    }
}

