/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Statement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_ReadOperation;

public abstract class ReadOperation
implements Serializable {
    public static ReadOperation create() {
        return new AutoValue_ReadOperation.Builder().setKeySet(KeySet.all()).build();
    }

    @Nullable
    public abstract Statement getQuery();

    @Nullable
    public abstract String getTable();

    @Nullable
    public abstract String getIndex();

    @Nullable
    public abstract List<String> getColumns();

    @Nullable
    public abstract KeySet getKeySet();

    abstract Builder toBuilder();

    public ReadOperation withTable(String table) {
        return this.toBuilder().setTable(table).build();
    }

    public ReadOperation withColumns(String ... columns) {
        return this.withColumns(Arrays.asList(columns));
    }

    public ReadOperation withColumns(List<String> columns) {
        return this.toBuilder().setColumns(columns).build();
    }

    public ReadOperation withQuery(Statement statement) {
        return this.toBuilder().setQuery(statement).build();
    }

    public ReadOperation withQuery(String sql) {
        return this.withQuery(Statement.of((String)sql));
    }

    public ReadOperation withKeySet(KeySet keySet) {
        return this.toBuilder().setKeySet(keySet).build();
    }

    public ReadOperation withIndex(String index) {
        return this.toBuilder().setIndex(index).build();
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder setQuery(Statement var1);

        abstract Builder setTable(String var1);

        abstract Builder setIndex(String var1);

        abstract Builder setColumns(List<String> var1);

        abstract Builder setKeySet(KeySet var1);

        abstract ReadOperation build();
    }
}

