/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.io.gcp.bigquery.AvroRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.transforms.SerializableFunction;

abstract class RowWriterFactory<ElementT, DestinationT>
implements Serializable {
    private RowWriterFactory() {
    }

    abstract OutputType getOutputType();

    abstract String getSourceFormat();

    abstract BigQueryRowWriter<ElementT> createRowWriter(String var1, DestinationT var2) throws Exception;

    static <ElementT, DestinationT> RowWriterFactory<ElementT, DestinationT> tableRows(SerializableFunction<ElementT, TableRow> toRow) {
        return new TableRowWriterFactory(toRow);
    }

    static <ElementT, DestinationT> RowWriterFactory<ElementT, DestinationT> avroRecords(SerializableFunction<AvroWriteRequest<ElementT>, GenericRecord> toAvro, SerializableFunction<TableSchema, Schema> schemaFactory, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        return new AvroRowWriterFactory(toAvro, schemaFactory, dynamicDestinations);
    }

    private static final class AvroRowWriterFactory<ElementT, DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final SerializableFunction<AvroWriteRequest<ElementT>, GenericRecord> toAvro;
        private final SerializableFunction<TableSchema, Schema> schemaFactory;
        private final DynamicDestinations<?, DestinationT> dynamicDestinations;

        private AvroRowWriterFactory(SerializableFunction<AvroWriteRequest<ElementT>, GenericRecord> toAvro, SerializableFunction<TableSchema, Schema> schemaFactory, DynamicDestinations<?, DestinationT> dynamicDestinations) {
            this.toAvro = toAvro;
            this.schemaFactory = schemaFactory;
            this.dynamicDestinations = dynamicDestinations;
        }

        @Override
        OutputType getOutputType() {
            return OutputType.AvroGenericRecord;
        }

        @Override
        BigQueryRowWriter<ElementT> createRowWriter(String tempFilePrefix, DestinationT destination) throws Exception {
            TableSchema tableSchema = this.dynamicDestinations.getSchema(destination);
            Schema avroSchema = (Schema)this.schemaFactory.apply((Object)tableSchema);
            return new AvroRowWriter<ElementT>(tempFilePrefix, avroSchema, this.toAvro);
        }

        @Override
        String getSourceFormat() {
            return "AVRO";
        }
    }

    static final class TableRowWriterFactory<ElementT, DestinationT>
    extends RowWriterFactory<ElementT, DestinationT> {
        private final SerializableFunction<ElementT, TableRow> toRow;

        private TableRowWriterFactory(SerializableFunction<ElementT, TableRow> toRow) {
            this.toRow = toRow;
        }

        public SerializableFunction<ElementT, TableRow> getToRowFn() {
            return this.toRow;
        }

        @Override
        public OutputType getOutputType() {
            return OutputType.JsonTableRow;
        }

        @Override
        public BigQueryRowWriter<ElementT> createRowWriter(String tempFilePrefix, DestinationT destination) throws Exception {
            return new TableRowWriter<ElementT>(tempFilePrefix, this.toRow);
        }

        @Override
        String getSourceFormat() {
            return "NEWLINE_DELIMITED_JSON";
        }
    }

    static enum OutputType {
        JsonTableRow,
        AvroGenericRecord;

    }
}

