/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryTableSourceDef
implements BigQuerySourceDef {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableSourceDef.class);
    private final BigQueryServices bqServices;
    private final ValueProvider<String> jsonTable;

    static BigQueryTableSourceDef create(BigQueryServices bqServices, ValueProvider<TableReference> table) {
        ValueProvider.NestedValueProvider jsonTable = ValueProvider.NestedValueProvider.of((ValueProvider)((ValueProvider)Preconditions.checkNotNull(table, (Object)"table")), (SerializableFunction)new BigQueryHelpers.TableRefToJson());
        return new BigQueryTableSourceDef(bqServices, (ValueProvider<String>)jsonTable);
    }

    private BigQueryTableSourceDef(BigQueryServices bqServices, ValueProvider<String> jsonTable) {
        this.bqServices = bqServices;
        this.jsonTable = jsonTable;
    }

    TableReference getTableReference(BigQueryOptions bqOptions) throws IOException {
        TableReference tableReference = (TableReference)BigQueryIO.JSON_FACTORY.fromString((String)this.jsonTable.get(), TableReference.class);
        return this.setDefaultProjectIfAbsent(bqOptions, tableReference);
    }

    private TableReference setDefaultProjectIfAbsent(BigQueryOptions bqOptions, TableReference tableReference) {
        if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)bqOptions.getProject()) ? 1 : 0) != 0, (String)"No project ID set in %s or %s, cannot construct a complete %s", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName(), (Object)TableReference.class.getSimpleName());
            LOG.info("Project ID not set in {}. Using default project from {}.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
            tableReference.setProjectId(bqOptions.getProject());
        }
        return tableReference;
    }

    ValueProvider<String> getJsonTable() {
        return this.jsonTable;
    }

    @Override
    public <T> BigQuerySourceBase<T> toSource(String stepUuid, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        return BigQueryTableSource.create(stepUuid, this, this.bqServices, coder, parseFn);
    }

    @Override
    public Schema getBeamSchema(BigQueryOptions bqOptions) {
        try {
            TableReference tableRef = this.getTableReference(bqOptions);
            TableSchema tableSchema = this.bqServices.getDatasetService(bqOptions).getTable(tableRef).getSchema();
            return BigQueryUtils.fromTableSchema(tableSchema);
        }
        catch (IOException | InterruptedException | NullPointerException e) {
            throw new BigQuerySchemaRetrievalException("Exception while trying to retrieve schema", e);
        }
    }
}

