/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_TypedRead;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Write;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BatchLoads;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.PrepareWrite;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingInserts;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    static final Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    static final SerializableFunction<TableRow, TableRow> IDENTITY_FORMATTER = (SerializableFunction & Serializable)input -> input;
    private static final SerializableFunction<TableSchema, org.apache.avro.Schema> DEFAULT_AVRO_SCHEMA_FACTORY = new SerializableFunction<TableSchema, org.apache.avro.Schema>(){

        public org.apache.avro.Schema apply(TableSchema input) {
            return BigQueryAvroUtils.toGenericAvroSchema("root", input.getFields());
        }
    };

    @Deprecated
    public static Read read() {
        return new Read();
    }

    public static TypedRead<TableRow> readTableRows() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of());
    }

    public static TypedRead<TableRow> readTableRowsWithSchema() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of()).withBeamRowConverters((TypeDescriptor<TableRow>)TypeDescriptor.of(TableRow.class), BigQueryUtils.tableRowToBeamRow(), BigQueryUtils.tableRowFromBeamRow());
    }

    public static <T> TypedRead<T> read(SerializableFunction<SchemaAndRecord, T> parseFn) {
        return new AutoValue_BigQueryIO_TypedRead.Builder().setValidate(true).setWithTemplateCompatibility(false).setBigQueryServices(new BigQueryServicesImpl()).setParseFn(parseFn).setMethod(TypedRead.Method.DEFAULT).build();
    }

    static String getExtractDestinationUri(String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    static List<ResourceId> getExtractFilePaths(String extractDestinationDir, Job extractJob) throws IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.isEmpty() ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        ResourceId extractDestinationDirResourceId = FileSystems.matchNewResource((String)extractDestinationDir, (boolean)true);
        for (long i = 0L; i < filesCount; ++i) {
            ResourceId filePath = extractDestinationDirResourceId.resolve(String.format("%012d%s", i, ".avro"), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_BigQueryIO_Write.Builder().setValidate(true).setBigQueryServices(new BigQueryServicesImpl()).setCreateDisposition(Write.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(Write.WriteDisposition.WRITE_EMPTY).setSchemaUpdateOptions(Collections.emptySet()).setNumFileShards(0).setMethod(Write.Method.DEFAULT).setExtendedErrorInfo(false).setSkipInvalidRows(false).setIgnoreUnknownValues(false).setMaxFilesPerPartition(10000).setMaxBytesPerPartition(0xB0000000000L).setOptimizeWrites(false).setUseBeamSchema(false).build();
    }

    public static Write<TableRow> writeTableRows() {
        return BigQueryIO.write().withFormatFunction(IDENTITY_FORMATTER);
    }

    @VisibleForTesting
    static void clearCreatedTables() {
        CreateTables.clearCreatedTables();
    }

    private BigQueryIO() {
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, WriteResult> {
        @Nullable
        abstract ValueProvider<String> getJsonTableRef();

        @Nullable
        abstract SerializableFunction<ValueInSingleWindow<T>, TableDestination> getTableFunction();

        @Nullable
        abstract SerializableFunction<T, TableRow> getFormatFunction();

        @Nullable
        abstract SerializableFunction<AvroWriteRequest<T>, GenericRecord> getAvroFormatFunction();

        @Nullable
        abstract SerializableFunction<TableSchema, org.apache.avro.Schema> getAvroSchemaFactory();

        @Nullable
        abstract DynamicDestinations<T, ?> getDynamicDestinations();

        @Nullable
        abstract PCollectionView<Map<String, String>> getSchemaFromView();

        @Nullable
        abstract ValueProvider<String> getJsonSchema();

        @Nullable
        abstract ValueProvider<String> getJsonTimePartitioning();

        @Nullable
        abstract Clustering getClustering();

        abstract CreateDisposition getCreateDisposition();

        abstract WriteDisposition getWriteDisposition();

        abstract Set<SchemaUpdateOption> getSchemaUpdateOptions();

        @Nullable
        abstract String getTableDescription();

        abstract boolean getValidate();

        abstract BigQueryServices getBigQueryServices();

        @Nullable
        abstract Integer getMaxFilesPerBundle();

        @Nullable
        abstract Long getMaxFileSize();

        abstract int getNumFileShards();

        abstract int getMaxFilesPerPartition();

        abstract long getMaxBytesPerPartition();

        @Nullable
        abstract Duration getTriggeringFrequency();

        abstract Method getMethod();

        @Nullable
        abstract ValueProvider<String> getLoadJobProjectId();

        @Nullable
        abstract InsertRetryPolicy getFailedInsertRetryPolicy();

        @Nullable
        abstract ValueProvider<String> getCustomGcsTempLocation();

        abstract boolean getExtendedErrorInfo();

        abstract Boolean getSkipInvalidRows();

        abstract Boolean getIgnoreUnknownValues();

        @Nullable
        abstract String getKmsKey();

        abstract Boolean getOptimizeWrites();

        abstract Boolean getUseBeamSchema();

        abstract Builder<T> toBuilder();

        public Write<T> to(String tableSpec) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public Write<T> to(TableReference table) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public Write<T> to(ValueProvider<String> tableSpec) {
            Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public Write<T> to(SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            Preconditions.checkArgument((tableFunction != null ? 1 : 0) != 0, (Object)"tableFunction can not be null");
            return this.toBuilder().setTableFunction(tableFunction).build();
        }

        public Write<T> to(DynamicDestinations<T, ?> dynamicDestinations) {
            Preconditions.checkArgument((dynamicDestinations != null ? 1 : 0) != 0, (Object)"dynamicDestinations can not be null");
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public Write<T> withFormatFunction(SerializableFunction<T, TableRow> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public Write<T> withAvroFormatFunction(SerializableFunction<AvroWriteRequest<T>, GenericRecord> avroFormatFunction) {
            return this.toBuilder().setAvroFormatFunction(avroFormatFunction).setOptimizeWrites(true).build();
        }

        public Write<T> withAvroSchemaFactory(SerializableFunction<TableSchema, org.apache.avro.Schema> avroSchemaFactory) {
            return this.toBuilder().setAvroSchemaFactory(avroSchemaFactory).build();
        }

        public Write<T> withSchema(TableSchema schema) {
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(schema)));
        }

        public Write<T> withSchema(ValueProvider<TableSchema> schema) {
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new BigQueryHelpers.TableSchemaToJsonSchema()));
        }

        public Write<T> withJsonSchema(String jsonSchema) {
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonSchema));
        }

        public Write<T> withJsonSchema(ValueProvider<String> jsonSchema) {
            Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.toBuilder().setJsonSchema(jsonSchema).build();
        }

        public Write<T> withSchemaFromView(PCollectionView<Map<String, String>> view) {
            Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"view can not be null");
            return this.toBuilder().setSchemaFromView(view).build();
        }

        public Write<T> withTimePartitioning(TimePartitioning partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(partitioning)));
        }

        public Write<T> withTimePartitioning(ValueProvider<TimePartitioning> partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.NestedValueProvider.of(partitioning, (SerializableFunction)new BigQueryHelpers.TimePartitioningToJson()));
        }

        public Write<T> withJsonTimePartitioning(ValueProvider<String> partitioning) {
            Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.toBuilder().setJsonTimePartitioning(partitioning).build();
        }

        public Write<T> withClustering(Clustering clustering) {
            Preconditions.checkArgument((clustering != null ? 1 : 0) != 0, (Object)"clustering can not be null");
            return this.toBuilder().setClustering(clustering).build();
        }

        public Write<T> withClustering() {
            return this.toBuilder().setClustering(new Clustering()).build();
        }

        public Write<T> withCreateDisposition(CreateDisposition createDisposition) {
            Preconditions.checkArgument((createDisposition != null ? 1 : 0) != 0, (Object)"createDisposition can not be null");
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public Write<T> withWriteDisposition(WriteDisposition writeDisposition) {
            Preconditions.checkArgument((writeDisposition != null ? 1 : 0) != 0, (Object)"writeDisposition can not be null");
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public Write<T> withSchemaUpdateOptions(Set<SchemaUpdateOption> schemaUpdateOptions) {
            Preconditions.checkArgument((schemaUpdateOptions != null ? 1 : 0) != 0, (Object)"schemaUpdateOptions can not be null");
            return this.toBuilder().setSchemaUpdateOptions(schemaUpdateOptions).build();
        }

        public Write<T> withTableDescription(String tableDescription) {
            Preconditions.checkArgument((tableDescription != null ? 1 : 0) != 0, (Object)"tableDescription can not be null");
            return this.toBuilder().setTableDescription(tableDescription).build();
        }

        public Write<T> withFailedInsertRetryPolicy(InsertRetryPolicy retryPolicy) {
            Preconditions.checkArgument((retryPolicy != null ? 1 : 0) != 0, (Object)"retryPolicy can not be null");
            return this.toBuilder().setFailedInsertRetryPolicy(retryPolicy).build();
        }

        public Write<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public Write<T> withMethod(Method method) {
            Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"method can not be null");
            return this.toBuilder().setMethod(method).build();
        }

        public Write<T> withLoadJobProjectId(String loadJobProjectId) {
            return this.withLoadJobProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)loadJobProjectId));
        }

        public Write<T> withLoadJobProjectId(ValueProvider<String> loadJobProjectId) {
            Preconditions.checkArgument((loadJobProjectId != null ? 1 : 0) != 0, (Object)"loadJobProjectId can not be null");
            return this.toBuilder().setLoadJobProjectId(loadJobProjectId).build();
        }

        public Write<T> withTriggeringFrequency(Duration triggeringFrequency) {
            Preconditions.checkArgument((triggeringFrequency != null ? 1 : 0) != 0, (Object)"triggeringFrequency can not be null");
            return this.toBuilder().setTriggeringFrequency(triggeringFrequency).build();
        }

        @Experimental
        public Write<T> withNumFileShards(int numFileShards) {
            Preconditions.checkArgument((numFileShards > 0 ? 1 : 0) != 0, (String)"numFileShards must be > 0, but was: %s", (int)numFileShards);
            return this.toBuilder().setNumFileShards(numFileShards).build();
        }

        public Write<T> withCustomGcsTempLocation(ValueProvider<String> customGcsTempLocation) {
            Preconditions.checkArgument((customGcsTempLocation != null ? 1 : 0) != 0, (Object)"customGcsTempLocation can not be null");
            return this.toBuilder().setCustomGcsTempLocation(customGcsTempLocation).build();
        }

        public Write<T> withExtendedErrorInfo() {
            return this.toBuilder().setExtendedErrorInfo(true).build();
        }

        public Write<T> skipInvalidRows() {
            return this.toBuilder().setSkipInvalidRows(true).build();
        }

        public Write<T> ignoreUnknownValues() {
            return this.toBuilder().setIgnoreUnknownValues(true).build();
        }

        public Write<T> withKmsKey(String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        @Experimental
        public Write<T> optimizedWrites() {
            return this.toBuilder().setOptimizeWrites(true).build();
        }

        @Experimental
        public Write<T> useBeamSchema() {
            return this.toBuilder().setUseBeamSchema(true).build();
        }

        @VisibleForTesting
        public Write<T> withTestServices(BigQueryServices testServices) {
            Preconditions.checkArgument((testServices != null ? 1 : 0) != 0, (Object)"testServices can not be null");
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public Write<T> withMaxFilesPerBundle(int maxFilesPerBundle) {
            Preconditions.checkArgument((maxFilesPerBundle > 0 ? 1 : 0) != 0, (String)"maxFilesPerBundle must be > 0, but was: %s", (int)maxFilesPerBundle);
            return this.toBuilder().setMaxFilesPerBundle(maxFilesPerBundle).build();
        }

        @VisibleForTesting
        Write<T> withMaxFileSize(long maxFileSize) {
            Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (String)"maxFileSize must be > 0, but was: %s", (long)maxFileSize);
            return this.toBuilder().setMaxFileSize(maxFileSize).build();
        }

        @VisibleForTesting
        Write<T> withMaxFilesPerPartition(int maxFilesPerPartition) {
            Preconditions.checkArgument((maxFilesPerPartition > 0 ? 1 : 0) != 0, (String)"maxFilesPerPartition must be > 0, but was: %s", (int)maxFilesPerPartition);
            return this.toBuilder().setMaxFilesPerPartition(maxFilesPerPartition).build();
        }

        @VisibleForTesting
        Write<T> withMaxBytesPerPartition(long maxBytesPerPartition) {
            Preconditions.checkArgument((maxBytesPerPartition > 0L ? 1 : 0) != 0, (String)"maxFilesPerPartition must be > 0, but was: %s", (long)maxBytesPerPartition);
            return this.toBuilder().setMaxBytesPerPartition(maxBytesPerPartition).build();
        }

        public void validate(PipelineOptions pipelineOptions) {
            BigQueryOptions options = (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class);
            if (this.getJsonTableRef() != null && this.getJsonTableRef().isAccessible() && this.getValidate()) {
                TableReference table = (TableReference)this.getTableWithDefaultProject(options).get();
                BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                BigQueryHelpers.verifyDatasetPresence(datasetService, table);
                if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                    BigQueryHelpers.verifyTablePresence(datasetService, table);
                }
                if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                    BigQueryHelpers.verifyTableNotExistOrEmpty(datasetService, table);
                }
            }
        }

        private Method resolveMethod(PCollection<T> input) {
            if (this.getMethod() != Method.DEFAULT) {
                return this.getMethod();
            }
            return input.isBounded() == PCollection.IsBounded.UNBOUNDED ? Method.STREAMING_INSERTS : Method.FILE_LOADS;
        }

        public WriteResult expand(PCollection<T> input) {
            DynamicDestinations<T, ?> dynamicDestinations;
            Preconditions.checkArgument((this.getTableFunction() != null || this.getJsonTableRef() != null || this.getDynamicDestinations() != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
            ArrayList allToArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonTableRef(), this.getTableFunction(), this.getDynamicDestinations()});
            Preconditions.checkArgument((1 == Iterables.size((Iterable)allToArgs.stream().filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"Exactly one of jsonTableRef, tableFunction, or dynamicDestinations must be set");
            ArrayList allSchemaArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonSchema(), this.getSchemaFromView(), this.getDynamicDestinations()});
            Preconditions.checkArgument((2 > Iterables.size((Iterable)allSchemaArgs.stream().filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"No more than one of jsonSchema, schemaFromView, or dynamicDestinations may be set");
            Method method = this.resolveMethod(input);
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED && method == Method.FILE_LOADS) {
                Preconditions.checkArgument((this.getTriggeringFrequency() != null ? 1 : 0) != 0, (Object)"When writing an unbounded PCollection via FILE_LOADS, triggering frequency must be specified");
            } else {
                Preconditions.checkArgument((this.getTriggeringFrequency() == null && this.getNumFileShards() == 0 ? 1 : 0) != 0, (String)"Triggering frequency or number of file shards can be specified only when writing an unbounded PCollection via FILE_LOADS, but: the collection was %s and the method was %s", (Object)input.isBounded(), (Object)((Object)method));
            }
            if (method != Method.FILE_LOADS) {
                Preconditions.checkArgument((this.getAvroFormatFunction() == null ? 1 : 0) != 0, (String)"Writing avro formatted data is only supported for FILE_LOADS, however the method was %s", (Object)((Object)method));
            }
            if (this.getJsonTimePartitioning() != null) {
                Preconditions.checkArgument((this.getDynamicDestinations() == null ? 1 : 0) != 0, (Object)"The supplied DynamicDestinations object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
                Preconditions.checkArgument((this.getTableFunction() == null ? 1 : 0) != 0, (Object)"The supplied getTableFunction object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
            }
            if (this.getClustering() != null && this.getClustering().getFields() != null) {
                Preconditions.checkArgument((this.getJsonTimePartitioning() != null ? 1 : 0) != 0, (Object)"Clustering fields can only be set when TimePartitioning is set.");
            }
            if ((dynamicDestinations = this.getDynamicDestinations()) == null) {
                if (this.getJsonTableRef() != null) {
                    dynamicDestinations = DynamicDestinationsHelpers.ConstantTableDestinations.fromJsonTableRef(this.getJsonTableRef(), this.getTableDescription());
                } else if (this.getTableFunction() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.TableFunctionDestinations<T>(this.getTableFunction(), this.getClustering() != null);
                }
                if (this.getJsonSchema() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations(dynamicDestinations, this.getJsonSchema());
                } else if (this.getSchemaFromView() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.SchemaFromViewDestinations<T>(dynamicDestinations, this.getSchemaFromView());
                }
                if (this.getJsonTimePartitioning() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantTimePartitioningDestinations<T>(dynamicDestinations, this.getJsonTimePartitioning(), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(this.getClustering())));
                }
            }
            return this.expandTyped(input, dynamicDestinations);
        }

        private <DestinationT> WriteResult expandTyped(PCollection<T> input, DynamicDestinations<T, DestinationT> dynamicDestinations) {
            boolean hasSchema;
            boolean optimizeWrites = this.getOptimizeWrites();
            SerializableFunction<T, TableRow> formatFunction = this.getFormatFunction();
            SerializableFunction<AvroWriteRequest<T>, GenericRecord> avroFormatFunction = this.getAvroFormatFunction();
            boolean bl = hasSchema = this.getJsonSchema() != null || this.getDynamicDestinations() != null || this.getSchemaFromView() != null;
            if (this.getUseBeamSchema().booleanValue()) {
                Preconditions.checkArgument((boolean)input.hasSchema());
                optimizeWrites = true;
                Preconditions.checkArgument((avroFormatFunction == null ? 1 : 0) != 0, (Object)"avroFormatFunction is unsupported when using Beam schemas.");
                if (formatFunction == null) {
                    formatFunction = BigQueryUtils.toTableRow(input.getToRowFunction());
                }
                TableSchema tableSchema = BigQueryUtils.toTableSchema(input.getSchema());
                dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations<T, DestinationT>(dynamicDestinations, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableSchema)));
            } else {
                Preconditions.checkArgument((this.getCreateDisposition() != CreateDisposition.CREATE_IF_NEEDED || hasSchema ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
            }
            Coder<DestinationT> destinationCoder = null;
            try {
                destinationCoder = dynamicDestinations.getDestinationCoderWithDefault(input.getPipeline().getCoderRegistry());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            Method method = this.resolveMethod(input);
            if (optimizeWrites) {
                RowWriterFactory rowWriterFactory;
                if (avroFormatFunction != null) {
                    Preconditions.checkArgument((formatFunction == null ? 1 : 0) != 0, (Object)"Only one of withFormatFunction or withAvroFormatFunction maybe set, not both.");
                    SerializableFunction avroSchemaFactory = this.getAvroSchemaFactory();
                    if (avroSchemaFactory == null) {
                        Preconditions.checkArgument((boolean)hasSchema, (Object)"A schema must be provided if an avroFormatFunction is set but no avroSchemaFactory is defined.");
                        avroSchemaFactory = DEFAULT_AVRO_SCHEMA_FACTORY;
                    }
                    rowWriterFactory = RowWriterFactory.avroRecords(avroFormatFunction, avroSchemaFactory, dynamicDestinations);
                } else if (formatFunction != null) {
                    rowWriterFactory = RowWriterFactory.tableRows(formatFunction);
                } else {
                    throw new IllegalArgumentException("A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
                }
                PCollection rowsWithDestination = ((PCollection)input.apply("PrepareWrite", new PrepareWrite(dynamicDestinations, SerializableFunctions.identity()))).setCoder((Coder)KvCoder.of(destinationCoder, (Coder)input.getCoder()));
                return this.continueExpandTyped(rowsWithDestination, input.getCoder(), destinationCoder, dynamicDestinations, rowWriterFactory, method);
            }
            Preconditions.checkArgument((avroFormatFunction == null ? 1 : 0) != 0);
            Preconditions.checkArgument((formatFunction != null ? 1 : 0) != 0, (Object)"A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
            PCollection rowsWithDestination = ((PCollection)input.apply("PrepareWrite", new PrepareWrite<T, DestinationT, TableRow>(dynamicDestinations, formatFunction))).setCoder((Coder)KvCoder.of(destinationCoder, (Coder)TableRowJsonCoder.of()));
            RowWriterFactory rowWriterFactory = RowWriterFactory.tableRows(SerializableFunctions.identity());
            return this.continueExpandTyped((PCollection)rowsWithDestination, (Coder)TableRowJsonCoder.of(), destinationCoder, dynamicDestinations, rowWriterFactory, method);
        }

        private <DestinationT, ElementT> WriteResult continueExpandTyped(PCollection<KV<DestinationT, ElementT>> input, Coder<ElementT> elementCoder, Coder<DestinationT> destinationCoder, DynamicDestinations<T, DestinationT> dynamicDestinations, RowWriterFactory<ElementT, DestinationT> rowWriterFactory, Method method) {
            if (method == Method.STREAMING_INSERTS) {
                Preconditions.checkArgument((this.getWriteDisposition() != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection.");
                InsertRetryPolicy retryPolicy = (InsertRetryPolicy)MoreObjects.firstNonNull((Object)this.getFailedInsertRetryPolicy(), (Object)InsertRetryPolicy.alwaysRetry());
                Preconditions.checkArgument((rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.JsonTableRow ? 1 : 0) != 0, (Object)"Avro output is not supported when method == STREAMING_INSERTS");
                RowWriterFactory.TableRowWriterFactory tableRowWriterFactory = (RowWriterFactory.TableRowWriterFactory)rowWriterFactory;
                StreamingInserts<DestinationT, ElementT> streamingInserts = new StreamingInserts<DestinationT, ElementT>(this.getCreateDisposition(), dynamicDestinations, elementCoder, tableRowWriterFactory.getToRowFn()).withInsertRetryPolicy(retryPolicy).withTestServices(this.getBigQueryServices()).withExtendedErrorInfo(this.getExtendedErrorInfo()).withSkipInvalidRows(this.getSkipInvalidRows()).withIgnoreUnknownValues(this.getIgnoreUnknownValues()).withKmsKey(this.getKmsKey());
                return (WriteResult)input.apply(streamingInserts);
            }
            Preconditions.checkArgument((this.getFailedInsertRetryPolicy() == null ? 1 : 0) != 0, (Object)"Record-insert retry policies are not supported when using BigQuery load jobs.");
            BatchLoads<DestinationT, ElementT> batchLoads = new BatchLoads<DestinationT, ElementT>(this.getWriteDisposition(), this.getCreateDisposition(), this.getJsonTableRef() != null, dynamicDestinations, destinationCoder, this.getCustomGcsTempLocation(), this.getLoadJobProjectId(), this.getIgnoreUnknownValues(), elementCoder, rowWriterFactory, this.getKmsKey());
            batchLoads.setTestServices(this.getBigQueryServices());
            if (this.getSchemaUpdateOptions() != null) {
                batchLoads.setSchemaUpdateOptions(this.getSchemaUpdateOptions());
            }
            if (this.getMaxFilesPerBundle() != null) {
                batchLoads.setMaxNumWritersPerBundle(this.getMaxFilesPerBundle());
            }
            if (this.getMaxFileSize() != null) {
                batchLoads.setMaxFileSize(this.getMaxFileSize());
            }
            batchLoads.setMaxFilesPerPartition(this.getMaxFilesPerPartition());
            batchLoads.setMaxBytesPerPartition(this.getMaxBytesPerPartition());
            if (PCollection.IsBounded.UNBOUNDED.equals((Object)input.isBounded())) {
                batchLoads.setMaxRetryJobs(1000);
            }
            batchLoads.setTriggeringFrequency(this.getTriggeringFrequency());
            batchLoads.setNumFileShards(this.getNumFileShards());
            return (WriteResult)input.apply(batchLoads);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", this.getJsonTableRef()).withLabel("Table Reference"));
            if (this.getJsonSchema() != null) {
                builder.addIfNotNull(DisplayData.item((String)"schema", this.getJsonSchema()).withLabel("Table Schema"));
            } else {
                builder.add(DisplayData.item((String)"schema", (String)"Custom Schema Function").withLabel("Table Schema"));
            }
            if (this.getTableFunction() != null) {
                builder.add(DisplayData.item((String)"tableFn", this.getTableFunction().getClass()).withLabel("Table Reference Function"));
            }
            builder.add(DisplayData.item((String)"createDisposition", (String)this.getCreateDisposition().toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.getWriteDisposition().toString()).withLabel("Table WriteDisposition")).add(DisplayData.item((String)"schemaUpdateOptions", (String)this.getSchemaUpdateOptions().toString()).withLabel("Table SchemaUpdateOptions")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true).addIfNotNull(DisplayData.item((String)"tableDescription", (String)this.getTableDescription()).withLabel("Table Description"));
        }

        @Nullable
        ValueProvider<TableReference> getTableWithDefaultProject(BigQueryOptions bqOptions) {
            ValueProvider<TableReference> table = this.getTable();
            if (table == null) {
                return table;
            }
            if (!table.isAccessible()) {
                LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                return table;
            }
            if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                TableReference tableRef = (TableReference)table.get();
                tableRef.setProjectId(bqOptions.getProject());
                return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableRef)), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
            }
            return table;
        }

        @Nullable
        public ValueProvider<TableReference> getTable() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public static enum SchemaUpdateOption {
            ALLOW_FIELD_ADDITION,
            ALLOW_FIELD_RELAXATION;

        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setJsonTableRef(ValueProvider<String> var1);

            abstract Builder<T> setTableFunction(SerializableFunction<ValueInSingleWindow<T>, TableDestination> var1);

            abstract Builder<T> setFormatFunction(SerializableFunction<T, TableRow> var1);

            abstract Builder<T> setAvroFormatFunction(SerializableFunction<AvroWriteRequest<T>, GenericRecord> var1);

            abstract Builder<T> setAvroSchemaFactory(SerializableFunction<TableSchema, org.apache.avro.Schema> var1);

            abstract Builder<T> setDynamicDestinations(DynamicDestinations<T, ?> var1);

            abstract Builder<T> setSchemaFromView(PCollectionView<Map<String, String>> var1);

            abstract Builder<T> setJsonSchema(ValueProvider<String> var1);

            abstract Builder<T> setJsonTimePartitioning(ValueProvider<String> var1);

            abstract Builder<T> setClustering(Clustering var1);

            abstract Builder<T> setCreateDisposition(CreateDisposition var1);

            abstract Builder<T> setWriteDisposition(WriteDisposition var1);

            abstract Builder<T> setSchemaUpdateOptions(Set<SchemaUpdateOption> var1);

            abstract Builder<T> setTableDescription(String var1);

            abstract Builder<T> setValidate(boolean var1);

            abstract Builder<T> setBigQueryServices(BigQueryServices var1);

            abstract Builder<T> setMaxFilesPerBundle(Integer var1);

            abstract Builder<T> setMaxFileSize(Long var1);

            abstract Builder<T> setNumFileShards(int var1);

            abstract Builder<T> setMaxFilesPerPartition(int var1);

            abstract Builder<T> setMaxBytesPerPartition(long var1);

            abstract Builder<T> setTriggeringFrequency(Duration var1);

            abstract Builder<T> setMethod(Method var1);

            abstract Builder<T> setLoadJobProjectId(ValueProvider<String> var1);

            abstract Builder<T> setFailedInsertRetryPolicy(InsertRetryPolicy var1);

            abstract Builder<T> setCustomGcsTempLocation(ValueProvider<String> var1);

            abstract Builder<T> setExtendedErrorInfo(boolean var1);

            abstract Builder<T> setSkipInvalidRows(Boolean var1);

            abstract Builder<T> setIgnoreUnknownValues(Boolean var1);

            abstract Builder<T> setKmsKey(String var1);

            abstract Builder<T> setOptimizeWrites(Boolean var1);

            abstract Builder<T> setUseBeamSchema(Boolean var1);

            abstract Write<T> build();
        }

        public static enum Method {
            DEFAULT,
            FILE_LOADS,
            STREAMING_INSERTS;

        }
    }

    @AutoValue
    public static abstract class TypedRead<T>
    extends PTransform<PBegin, PCollection<T>> {
        private static final String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

        abstract Builder<T> toBuilder();

        @Nullable
        abstract ValueProvider<String> getJsonTableRef();

        @Nullable
        abstract ValueProvider<String> getQuery();

        abstract boolean getValidate();

        @Nullable
        abstract Boolean getFlattenResults();

        @Nullable
        abstract Boolean getUseLegacySql();

        abstract Boolean getWithTemplateCompatibility();

        abstract BigQueryServices getBigQueryServices();

        abstract SerializableFunction<SchemaAndRecord, T> getParseFn();

        @Nullable
        abstract QueryPriority getQueryPriority();

        @Nullable
        abstract String getQueryLocation();

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        abstract Method getMethod();

        @Deprecated
        @Nullable
        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        abstract ReadOptions.TableReadOptions getReadOptions();

        @Nullable
        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        abstract ValueProvider<List<String>> getSelectedFields();

        @Nullable
        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        abstract ValueProvider<String> getRowRestriction();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract String getKmsKey();

        @Nullable
        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract TypeDescriptor<T> getTypeDescriptor();

        @Nullable
        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract ToBeamRowFunction<T> getToBeamRowFn();

        @Nullable
        @Experimental(value=Experimental.Kind.SCHEMAS)
        abstract FromBeamRowFunction<T> getFromBeamRowFn();

        @VisibleForTesting
        Coder<T> inferCoder(CoderRegistry coderRegistry) {
            if (this.getCoder() != null) {
                return this.getCoder();
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(this.getParseFn()));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        private BigQuerySourceDef createSourceDef() {
            BigQuerySourceDef sourceDef = this.getQuery() == null ? BigQueryTableSourceDef.create(this.getBigQueryServices(), this.getTableProvider()) : BigQueryQuerySourceDef.create(this.getBigQueryServices(), this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getKmsKey());
            return sourceDef;
        }

        private BigQueryStorageQuerySource<T> createStorageQuerySource(String stepUuid, Coder<T> outputCoder) {
            return BigQueryStorageQuerySource.create(stepUuid, this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getKmsKey(), this.getParseFn(), outputCoder, this.getBigQueryServices());
        }

        public void validate(PipelineOptions options) {
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            if (this.getMethod() != Method.DIRECT_READ) {
                String tempLocation = bqOptions.getTempLocation();
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Read needs a GCS temp location to store temp files.");
                if (this.getBigQueryServices() == null) {
                    try {
                        GcsPath.fromUri((String)tempLocation);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                    }
                }
            }
            ValueProvider<TableReference> table = this.getTableProvider();
            if (this.getValidate()) {
                if (table != null) {
                    Preconditions.checkArgument((boolean)table.isAccessible(), (Object)"Cannot call validate if table is dynamically set.");
                }
                if (table != null && ((TableReference)table.get()).getProjectId() != null) {
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);
                    BigQueryHelpers.verifyDatasetPresence(datasetService, (TableReference)table.get());
                    BigQueryHelpers.verifyTablePresence(datasetService, (TableReference)table.get());
                } else if (this.getQuery() != null) {
                    Preconditions.checkArgument((boolean)this.getQuery().isAccessible(), (Object)"Cannot call validate if query is dynamically set.");
                    BigQueryServices.JobService jobService = this.getBigQueryServices().getJobService(bqOptions);
                    try {
                        jobService.dryRunQuery(bqOptions.getProject(), new JobConfigurationQuery().setQuery((String)this.getQuery().get()).setFlattenResults(this.getFlattenResults()).setUseLegacySql(this.getUseLegacySql()), this.getQueryLocation());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.getQuery().get()), e);
                    }
                }
            }
        }

        public PCollection<T> expand(PBegin input) {
            PCollection rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> table = this.getTableProvider();
            if (table != null) {
                Preconditions.checkArgument((this.getQuery() == null ? 1 : 0) != 0, (Object)"from() and fromQuery() are exclusive");
                Preconditions.checkArgument((this.getQueryPriority() == null ? 1 : 0) != 0, (Object)"withQueryPriority() can only be specified when using fromQuery()");
                Preconditions.checkArgument((this.getFlattenResults() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
                Preconditions.checkArgument((this.getUseLegacySql() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
                if (table.isAccessible() && Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    LOG.info("Project of {} not set. The value of {}.getProject() at execution time will be used.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                }
            } else {
                Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"Either from() or fromQuery() is required");
                Preconditions.checkArgument((this.getFlattenResults() != null ? 1 : 0) != 0, (Object)"flattenResults should not be null if query is set");
                Preconditions.checkArgument((this.getUseLegacySql() != null ? 1 : 0) != 0, (Object)"useLegacySql should not be null if query is set");
            }
            Preconditions.checkArgument((this.getParseFn() != null ? 1 : 0) != 0, (Object)"A parseFn is required");
            boolean beamSchemaEnabled = false;
            if (this.getTypeDescriptor() != null && this.getToBeamRowFn() != null && this.getFromBeamRowFn() != null) {
                beamSchemaEnabled = true;
            }
            Pipeline p = input.getPipeline();
            final Coder<T> coder = this.inferCoder(p.getCoderRegistry());
            if (this.getMethod() == Method.DIRECT_READ) {
                return this.expandForDirectRead(input, coder);
            }
            Preconditions.checkArgument((this.getReadOptions() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies table read options, which only applies when using Method.DIRECT_READ");
            Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when using Method.DIRECT_READ");
            Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when using Method.DIRECT_READ");
            final BigQuerySourceDef sourceDef = this.createSourceDef();
            if (!this.getWithTemplateCompatibility().booleanValue()) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(sourceDef.toSource(staticJobUuid, coder, this.getParseFn())));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public String apply(String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag filesTag = new TupleTag();
                final TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunCreateJob", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext c) throws Exception {
                        String jobUuid = (String)c.element();
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getParseFn());
                        BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                        BigQuerySourceBase.ExtractResult res = source.extractFiles(options);
                        LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
                        source.cleanupTempResource(options);
                        for (ResourceId file : res.extractedFiles) {
                            c.output((Object)file.toString());
                        }
                        c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(res.schema));
                    }
                }).withOutputTags(filesTag, TupleTagList.of((TupleTag)tableSchemaTag)));
                tuple.get(filesTag).setCoder((Coder)StringUtf8Coder.of());
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                final PCollectionView schemaView = (PCollectionView)tuple.get(tableSchemaTag).apply((PTransform)View.asSingleton());
                rows = ((PCollection)((PCollection)tuple.get(filesTag).apply((PTransform)Reshuffle.viaRandomKey())).apply("ReadFiles", (PTransform)ParDo.of((DoFn)new DoFn<String, T>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext c) throws Exception {
                        TableSchema schema = BigQueryHelpers.fromJsonString((String)c.sideInput(schemaView), TableSchema.class);
                        String jobUuid = (String)c.sideInput(jobIdTokenView);
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getParseFn());
                        List sources = source.createSources((List<ResourceId>)ImmutableList.of((Object)FileSystems.matchNewResource((String)((String)c.element()), (boolean)false)), schema, null);
                        Preconditions.checkArgument((sources.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one source.");
                        BoundedSource avroSource = sources.get(0);
                        BoundedSource.BoundedReader reader = avroSource.createReader(c.getPipelineOptions());
                        boolean more = reader.start();
                        while (more) {
                            c.output(reader.getCurrent());
                            more = reader.advance();
                        }
                    }
                }).withSideInputs(new PCollectionView[]{schemaView, jobIdTokenView}))).setCoder(coder);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
                    List<ResourceId> extractFiles;
                    PipelineOptions options = c.getPipelineOptions();
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", jobUuid);
                    String executingProject = bqOptions.getProject();
                    JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(BigQueryHelpers.getExtractJobId(BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), jobUuid)));
                    Job extractJob = this.getBigQueryServices().getJobService(bqOptions).getJob(jobRef);
                    if (extractJob != null && (extractFiles = BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob)) != null && !extractFiles.isEmpty()) {
                        FileSystems.delete(extractFiles, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                }
            };
            rows = (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
            if (beamSchemaEnabled) {
                BigQueryOptions bqOptions = (BigQueryOptions)p.getOptions().as(BigQueryOptions.class);
                Schema beamSchema = sourceDef.getBeamSchema(bqOptions);
                SerializableFunction toBeamRow = (SerializableFunction)this.getToBeamRowFn().apply(beamSchema);
                SerializableFunction fromBeamRow = (SerializableFunction)this.getFromBeamRowFn().apply(beamSchema);
                rows.setSchema(beamSchema, this.getTypeDescriptor(), toBeamRow, fromBeamRow);
            }
            return rows;
        }

        private PCollection<T> expandForDirectRead(PBegin input, final Coder<T> outputCoder) {
            PCollection rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> tableProvider = this.getTableProvider();
            Pipeline p = input.getPipeline();
            if (tableProvider != null) {
                return (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(BigQueryStorageTableSource.create(tableProvider, this.getReadOptions(), this.getSelectedFields(), this.getRowRestriction(), this.getParseFn(), outputCoder, this.getBigQueryServices())));
            }
            Preconditions.checkArgument((this.getReadOptions() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies table read options, which only applies when reading from a table");
            Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when reading from a table");
            Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when reading from a table");
            if (!this.getWithTemplateCompatibility().booleanValue()) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createStorageQuerySource(staticJobUuid, outputCoder)));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public String apply(String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag streamsTag = new TupleTag();
                final TupleTag readSessionTag = new TupleTag();
                final TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunQueryJob", (PTransform)ParDo.of((DoFn)new DoFn<String, Storage.Stream>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext c) throws Exception {
                        Storage.ReadSession readSession;
                        BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                        String jobUuid = (String)c.element();
                        BigQueryStorageQuerySource querySource = this.createStorageQuerySource(jobUuid, outputCoder);
                        Table queryResultTable = querySource.getTargetTable(options);
                        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + options.getProject()).setTableReference(BigQueryHelpers.toTableRefProto(queryResultTable.getTableReference())).setRequestedStreams(0).build();
                        try (BigQueryServices.StorageClient storageClient = this.getBigQueryServices().getStorageClient(options);){
                            readSession = storageClient.createReadSession(request);
                        }
                        for (Storage.Stream stream : readSession.getStreamsList()) {
                            c.output((Object)stream);
                        }
                        c.output(readSessionTag, (Object)readSession);
                        c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(queryResultTable.getSchema()));
                    }
                }).withOutputTags(streamsTag, TupleTagList.of((TupleTag)readSessionTag).and(tableSchemaTag)));
                tuple.get(streamsTag).setCoder((Coder)ProtoCoder.of(Storage.Stream.class));
                tuple.get(readSessionTag).setCoder((Coder)ProtoCoder.of(Storage.ReadSession.class));
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                final PCollectionView readSessionView = (PCollectionView)tuple.get(readSessionTag).apply("ReadSessionView", (PTransform)View.asSingleton());
                final PCollectionView tableSchemaView = (PCollectionView)tuple.get(tableSchemaTag).apply("TableSchemaView", (PTransform)View.asSingleton());
                rows = ((PCollection)((PCollection)tuple.get(streamsTag).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)ParDo.of((DoFn)new DoFn<Storage.Stream, T>(){

                    @DoFn.ProcessElement
                    public void processElement(DoFn.ProcessContext c) throws Exception {
                        Storage.ReadSession readSession = (Storage.ReadSession)c.sideInput(readSessionView);
                        TableSchema tableSchema = BigQueryHelpers.fromJsonString((String)c.sideInput(tableSchemaView), TableSchema.class);
                        Storage.Stream stream = (Storage.Stream)c.element();
                        BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create(readSession, stream, tableSchema, this.getParseFn(), outputCoder, this.getBigQueryServices());
                        BoundedSource.BoundedReader reader = streamSource.createReader(c.getPipelineOptions());
                        boolean more = reader.start();
                        while (more) {
                            c.output(reader.getCurrent());
                            more = reader.advance();
                        }
                    }
                }).withSideInputs(new PCollectionView[]{readSessionView, tableSchemaView}))).setCoder(outputCoder);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
                    BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    TableReference tempTable = BigQueryHelpers.createTempTableReference(options.getProject(), BigQueryHelpers.createJobIdToken(options.getJobName(), jobUuid));
                    BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                    LOG.info("Deleting temporary table with query results {}", (Object)tempTable);
                    datasetService.deleteTable(tempTable);
                    LOG.info("Deleting temporary dataset with query results {}", (Object)tempTable.getDatasetId());
                    datasetService.deleteDataset(tempTable.getProjectId(), tempTable.getDatasetId());
                }
            };
            return (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.getTableProvider())).withLabel("Table")).addIfNotNull(DisplayData.item((String)"query", this.getQuery()).withLabel("Query")).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.getFlattenResults()).withLabel("Flatten Query Results")).addIfNotNull(DisplayData.item((String)"useLegacySql", (Boolean)this.getUseLegacySql()).withLabel("Use Legacy SQL Dialect")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true);
        }

        private void ensureFromNotCalledYet() {
            Preconditions.checkState((this.getJsonTableRef() == null && this.getQuery() == null ? 1 : 0) != 0, (Object)"from() or fromQuery() already called");
        }

        private void ensureReadOptionsNotSet() {
            Preconditions.checkState((this.getReadOptions() == null ? 1 : 0) != 0, (Object)"withReadOptions() already called");
        }

        private void ensureReadOptionsFieldsNotSet() {
            Preconditions.checkState((this.getSelectedFields() == null && this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"setSelectedFields() or setRowRestriction already called");
        }

        @Nullable
        public ValueProvider<TableReference> getTableProvider() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        @Nullable
        public TableReference getTable() {
            ValueProvider<TableReference> provider = this.getTableProvider();
            return provider == null ? null : (TableReference)provider.get();
        }

        public TypedRead<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public TypedRead<T> withKmsKey(String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public TypedRead<T> withBeamRowConverters(TypeDescriptor<T> typeDescriptor, ToBeamRowFunction<T> toRowFn, FromBeamRowFunction<T> fromRowFn) {
            return this.toBuilder().setTypeDescriptor(typeDescriptor).setToBeamRowFn(toRowFn).setFromBeamRowFn(fromRowFn).build();
        }

        public TypedRead<T> from(String tableSpec) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public TypedRead<T> from(ValueProvider<String> tableSpec) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public TypedRead<T> fromQuery(String query) {
            return this.fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public TypedRead<T> fromQuery(ValueProvider<String> query) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setQuery(query).setFlattenResults(true).setUseLegacySql(true).build();
        }

        public TypedRead<T> from(TableReference table) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public TypedRead<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public TypedRead<T> withoutResultFlattening() {
            return this.toBuilder().setFlattenResults(false).build();
        }

        public TypedRead<T> usingStandardSql() {
            return this.toBuilder().setUseLegacySql(false).build();
        }

        public TypedRead<T> withQueryPriority(QueryPriority priority) {
            return this.toBuilder().setQueryPriority(priority).build();
        }

        public TypedRead<T> withQueryLocation(String location) {
            return this.toBuilder().setQueryLocation(location).build();
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withMethod(Method method) {
            return this.toBuilder().setMethod(method).build();
        }

        @Deprecated
        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withReadOptions(ReadOptions.TableReadOptions readOptions) {
            this.ensureReadOptionsFieldsNotSet();
            return this.toBuilder().setReadOptions(readOptions).build();
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withSelectedFields(List<String> selectedFields) {
            return this.withSelectedFields((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(selectedFields));
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withSelectedFields(ValueProvider<List<String>> selectedFields) {
            this.ensureReadOptionsNotSet();
            return this.toBuilder().setSelectedFields(selectedFields).build();
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withRowRestriction(String rowRestriction) {
            return this.withRowRestriction((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rowRestriction));
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withRowRestriction(ValueProvider<String> rowRestriction) {
            this.ensureReadOptionsNotSet();
            return this.toBuilder().setRowRestriction(rowRestriction).build();
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public TypedRead<T> withTemplateCompatibility() {
            return this.toBuilder().setWithTemplateCompatibility(true).build();
        }

        @VisibleForTesting
        TypedRead<T> withTestServices(BigQueryServices testServices) {
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public static enum QueryPriority {
            INTERACTIVE,
            BATCH;

        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setJsonTableRef(ValueProvider<String> var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setValidate(boolean var1);

            abstract Builder<T> setFlattenResults(Boolean var1);

            abstract Builder<T> setUseLegacySql(Boolean var1);

            abstract Builder<T> setWithTemplateCompatibility(Boolean var1);

            abstract Builder<T> setBigQueryServices(BigQueryServices var1);

            abstract Builder<T> setQueryPriority(QueryPriority var1);

            abstract Builder<T> setQueryLocation(String var1);

            @Experimental(value=Experimental.Kind.SOURCE_SINK)
            abstract Builder<T> setMethod(Method var1);

            @Deprecated
            @Experimental(value=Experimental.Kind.SOURCE_SINK)
            abstract Builder<T> setReadOptions(ReadOptions.TableReadOptions var1);

            @Experimental(value=Experimental.Kind.SOURCE_SINK)
            abstract Builder<T> setSelectedFields(ValueProvider<List<String>> var1);

            @Experimental(value=Experimental.Kind.SOURCE_SINK)
            abstract Builder<T> setRowRestriction(ValueProvider<String> var1);

            abstract TypedRead<T> build();

            abstract Builder<T> setParseFn(SerializableFunction<SchemaAndRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setKmsKey(String var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract Builder<T> setTypeDescriptor(TypeDescriptor<T> var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract Builder<T> setToBeamRowFn(ToBeamRowFunction<T> var1);

            @Experimental(value=Experimental.Kind.SCHEMAS)
            abstract Builder<T> setFromBeamRowFn(FromBeamRowFunction<T> var1);
        }

        static interface FromBeamRowFunction<T>
        extends SerializableFunction<Schema, SerializableFunction<Row, T>> {
        }

        static interface ToBeamRowFunction<T>
        extends SerializableFunction<Schema, SerializableFunction<T, Row>> {
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public static enum Method {
            DEFAULT,
            EXPORT,
            DIRECT_READ;

        }
    }

    public static class Read
    extends PTransform<PBegin, PCollection<TableRow>> {
        private final TypedRead<TableRow> inner;

        Read() {
            this(BigQueryIO.read(TableRowParser.INSTANCE).withCoder((Coder<TableRow>)TableRowJsonCoder.of()));
        }

        Read(TypedRead<TableRow> inner) {
            this.inner = inner;
        }

        public PCollection<TableRow> expand(PBegin input) {
            return (PCollection)input.apply(this.inner);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        boolean getValidate() {
            return this.inner.getValidate();
        }

        ValueProvider<String> getQuery() {
            return this.inner.getQuery();
        }

        Read withTestServices(BigQueryServices testServices) {
            return new Read(this.inner.withTestServices(testServices));
        }

        @Nullable
        public ValueProvider<TableReference> getTableProvider() {
            return this.inner.getTableProvider();
        }

        @Nullable
        public TableReference getTable() {
            return this.inner.getTable();
        }

        public Read from(String tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public Read from(ValueProvider<String> tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public Read from(TableReference table) {
            return new Read(this.inner.from(table));
        }

        public Read fromQuery(String query) {
            return new Read(this.inner.fromQuery(query));
        }

        public Read fromQuery(ValueProvider<String> query) {
            return new Read(this.inner.fromQuery(query));
        }

        public Read withoutValidation() {
            return new Read(this.inner.withoutValidation());
        }

        public Read withoutResultFlattening() {
            return new Read(this.inner.withoutResultFlattening());
        }

        public Read usingStandardSql() {
            return new Read(this.inner.usingStandardSql());
        }

        @Experimental(value=Experimental.Kind.SOURCE_SINK)
        public Read withTemplateCompatibility() {
            return new Read(this.inner.withTemplateCompatibility());
        }
    }

    @VisibleForTesting
    static class TableRowParser
    implements SerializableFunction<SchemaAndRecord, TableRow> {
        public static final TableRowParser INSTANCE = new TableRowParser();

        TableRowParser() {
        }

        public TableRow apply(SchemaAndRecord schemaAndRecord) {
            return BigQueryAvroUtils.convertGenericRecordToTableRow(schemaAndRecord.getRecord(), schemaAndRecord.getTableSchema());
        }
    }
}

