/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@AutoValue
public abstract class SpannerConfig
implements Serializable {
    private static final String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private static final String DEFAULT_HOST = "https://batch-spanner.googleapis.com/";

    @Nullable
    public abstract ValueProvider<String> getProjectId();

    @Nullable
    public abstract ValueProvider<String> getInstanceId();

    @Nullable
    public abstract ValueProvider<String> getDatabaseId();

    @Nullable
    public abstract ValueProvider<String> getHost();

    @Nullable
    @VisibleForTesting
    abstract ServiceFactory<Spanner, SpannerOptions> getServiceFactory();

    abstract Builder toBuilder();

    public static SpannerConfig create() {
        return SpannerConfig.builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_HOST)).build();
    }

    static Builder builder() {
        return new AutoValue_SpannerConfig.Builder();
    }

    public void validate() {
        Preconditions.checkNotNull(this.getInstanceId(), (Object)"SpannerIO.read() requires instance id to be set with withInstanceId method");
        Preconditions.checkNotNull(this.getDatabaseId(), (Object)"SpannerIO.read() requires database id to be set with withDatabaseId method");
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Output Project")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Output Instance")).addIfNotNull(DisplayData.item((String)"databaseId", this.getDatabaseId()).withLabel("Output Database"));
        if (this.getServiceFactory() != null) {
            builder.addIfNotNull(DisplayData.item((String)"serviceFactory", (String)this.getServiceFactory().getClass().getName()).withLabel("Service Factory"));
        }
    }

    public SpannerConfig withProjectId(ValueProvider<String> projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public SpannerConfig withProjectId(String projectId) {
        return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
    }

    public SpannerConfig withInstanceId(ValueProvider<String> instanceId) {
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public SpannerConfig withInstanceId(String instanceId) {
        return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
    }

    public SpannerConfig withDatabaseId(ValueProvider<String> databaseId) {
        return this.toBuilder().setDatabaseId(databaseId).build();
    }

    public SpannerConfig withDatabaseId(String databaseId) {
        return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
    }

    public SpannerConfig withHost(ValueProvider<String> host) {
        return this.toBuilder().setHost(host).build();
    }

    @VisibleForTesting
    SpannerConfig withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
        return this.toBuilder().setServiceFactory(serviceFactory).build();
    }

    public SpannerAccessor connectToSpanner() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        if (this.getProjectId() != null) {
            builder.setProjectId((String)this.getProjectId().get());
        }
        if (this.getServiceFactory() != null) {
            builder.setServiceFactory(this.getServiceFactory());
        }
        if (this.getHost() != null) {
            builder.setHost((String)this.getHost().get());
        }
        String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
        builder.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{"user-agent", userAgentString}));
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)((String)this.getInstanceId().get()), (String)((String)this.getDatabaseId().get())));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)((String)this.getInstanceId().get()), (String)((String)this.getDatabaseId().get())));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setProjectId(ValueProvider<String> var1);

        abstract Builder setInstanceId(ValueProvider<String> var1);

        abstract Builder setDatabaseId(ValueProvider<String> var1);

        abstract Builder setHost(ValueProvider<String> var1);

        abstract Builder setServiceFactory(ServiceFactory<Spanner, SpannerOptions> var1);

        public abstract SpannerConfig build();
    }
}

