/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class BigQueryQuerySource<T>
extends BigQuerySourceBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryQuerySource.class);
    private final BigQueryQuerySourceDef queryDef;

    static <T> BigQueryQuerySource<T> create(String stepUuid, BigQueryQuerySourceDef queryDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        return new BigQueryQuerySource<T>(stepUuid, queryDef, bqServices, coder, parseFn);
    }

    private BigQueryQuerySource(String stepUuid, BigQueryQuerySourceDef queryDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        super(stepUuid, bqServices, coder, parseFn);
        this.queryDef = queryDef;
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.queryDef.getEstimatedSizeBytes((BigQueryOptions)options.as(BigQueryOptions.class));
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException, InterruptedException {
        return this.queryDef.getTableReference(bqOptions, this.stepUuid);
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
        this.queryDef.cleanupTempResource(bqOptions, this.stepUuid);
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.queryDef.getQuery()));
    }
}

