/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigqueryClient {
    private static final Logger LOG = LoggerFactory.getLogger(BigqueryClient.class);
    static final int MAX_QUERY_RETRIES = 4;
    static final Long QUERY_TIMEOUT_MS = 20000L;
    private static final Duration INITIAL_BACKOFF = Duration.standardSeconds((long)1L);
    static final FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(INITIAL_BACKOFF);
    private static final Collection<String> RESERVED_FIELD_NAMES = ClassInfo.of(TableRow.class).getNames();
    private Bigquery bqClient;

    private static Credentials getDefaultCredential() {
        GoogleCredentials credential;
        try {
            credential = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get application default credential.", e);
        }
        if (credential.createScopedRequired()) {
            ArrayList bigqueryScope = Lists.newArrayList((Iterable)BigqueryScopes.all());
            credential = credential.createScoped((Collection)bigqueryScope);
        }
        return credential;
    }

    public static Bigquery getNewBigquerryClient(String applicationName) {
        HttpTransport transport = Transport.getTransport();
        JsonFactory jsonFactory = Transport.getJsonFactory();
        Credentials credential = BigqueryClient.getDefaultCredential();
        return new Bigquery.Builder(transport, jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter(credential)).setApplicationName(applicationName).build();
    }

    public static BigqueryClient getClient(String applicationName) {
        return new BigqueryClient(applicationName);
    }

    public BigqueryClient(String applicationName) {
        this.bqClient = BigqueryClient.getNewBigquerryClient(applicationName);
    }

    @Nonnull
    public QueryResponse queryWithRetries(String query, String projectId) throws IOException, InterruptedException {
        return this.queryWithRetries(query, projectId, false);
    }

    @Nullable
    private Object getTypedCellValue(TableFieldSchema fieldSchema, Object v) {
        if (Data.isNull((Object)v)) {
            return null;
        }
        if (Objects.equals(fieldSchema.getMode(), "REPEATED")) {
            TableFieldSchema elementSchema = fieldSchema.clone().setMode("REQUIRED");
            List rawCells = (List)v;
            ImmutableList.Builder values = ImmutableList.builder();
            for (Map element : rawCells) {
                values.add(this.getTypedCellValue(elementSchema, element.get("v")));
            }
            return values.build();
        }
        if ("RECORD".equals(fieldSchema.getType())) {
            Map typedV = (Map)v;
            return this.getTypedTableRow(fieldSchema.getFields(), typedV);
        }
        if ("FLOAT".equals(fieldSchema.getType())) {
            return Double.parseDouble((String)v);
        }
        if ("BOOLEAN".equals(fieldSchema.getType())) {
            return Boolean.parseBoolean((String)v);
        }
        if ("TIMESTAMP".equals(fieldSchema.getType())) {
            return (String)v;
        }
        return v;
    }

    private TableRow getTypedTableRow(List<TableFieldSchema> fields, Map<String, Object> rawRow) {
        List cells;
        TableRow row;
        if (rawRow instanceof TableRow) {
            row = (TableRow)rawRow;
            cells = row.getF();
            row.setF(null);
        } else {
            List rawCells;
            row = new TableRow();
            cells = rawCells = (List)rawRow.get("f");
        }
        Preconditions.checkState((cells.size() == fields.size() ? 1 : 0) != 0, (String)"Expected that the row has the same number of cells %s as fields in the schema %s", (int)cells.size(), (int)fields.size());
        Iterator cellIt = cells.iterator();
        Iterator<TableFieldSchema> fieldIt = fields.iterator();
        while (cellIt.hasNext()) {
            Map cell = (Map)cellIt.next();
            TableFieldSchema fieldSchema = fieldIt.next();
            Object convertedValue = this.getTypedCellValue(fieldSchema, cell.get("v"));
            String fieldName = fieldSchema.getName();
            Preconditions.checkArgument((!RESERVED_FIELD_NAMES.contains(fieldName) ? 1 : 0) != 0, (String)"BigQueryIO does not support records with columns named %s", (Object)fieldName);
            if (convertedValue == null) continue;
            row.set(fieldName, convertedValue);
        }
        return row;
    }

    private QueryResponse getTypedTableRows(QueryResponse response) {
        List rows = response.getRows();
        TableSchema schema = response.getSchema();
        response.setRows(rows.stream().map(r -> this.getTypedTableRow(schema.getFields(), (Map<String, Object>)r)).collect(Collectors.toList()));
        return response;
    }

    @Nonnull
    public List<TableRow> queryUnflattened(String query, String projectId, boolean typed) throws IOException, InterruptedException {
        GetQueryResultsResponse qResponse;
        Random rnd = new Random(System.currentTimeMillis());
        String temporaryDatasetId = "_dataflow_temporary_dataset_" + rnd.nextInt(1000000);
        String temporaryTableId = "dataflow_temporary_table_" + rnd.nextInt(1000000);
        TableReference tempTableReference = new TableReference().setProjectId(projectId).setDatasetId(temporaryDatasetId).setTableId(temporaryTableId);
        this.createNewDataset(projectId, temporaryDatasetId);
        this.createNewTable(projectId, temporaryDatasetId, new Table().setTableReference(tempTableReference));
        JobConfigurationQuery jcQuery = new JobConfigurationQuery().setFlattenResults(Boolean.valueOf(false)).setAllowLargeResults(Boolean.valueOf(true)).setDestinationTable(tempTableReference).setQuery(query);
        JobConfiguration jc = new JobConfiguration().setQuery(jcQuery);
        Job job = new Job().setConfiguration(jc);
        Job insertedJob = (Job)this.bqClient.jobs().insert(projectId, job).execute();
        while (!(qResponse = (GetQueryResultsResponse)this.bqClient.jobs().getQueryResults(projectId, insertedJob.getJobReference().getJobId()).execute()).getJobComplete().booleanValue()) {
        }
        TableSchema schema = qResponse.getSchema();
        List rows = qResponse.getRows();
        this.deleteDataset(projectId, temporaryDatasetId);
        return !typed ? rows : rows.stream().map(r -> this.getTypedTableRow(schema.getFields(), (Map<String, Object>)r)).collect(Collectors.toList());
    }

    @Nonnull
    public QueryResponse queryWithRetries(String query, String projectId, boolean typed) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        QueryRequest bqQueryRequest = new QueryRequest().setQuery(query).setTimeoutMs(QUERY_TIMEOUT_MS);
        do {
            if (lastException != null) {
                LOG.warn("Retrying query ({}) after exception", (Object)bqQueryRequest.getQuery(), (Object)lastException);
            }
            try {
                QueryResponse response = (QueryResponse)this.bqClient.jobs().query(projectId, bqQueryRequest).execute();
                if (response != null) {
                    return typed ? this.getTypedTableRows(response) : response;
                }
                lastException = new IOException("Expected valid response from query job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times using query (%s)", 4, bqQueryRequest.getQuery()), lastException);
    }

    public void createNewDataset(String projectId, String datasetId) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying insert dataset ({}) after exception", (Object)datasetId, lastException);
            }
            try {
                Dataset response = (Dataset)this.bqClient.datasets().insert(projectId, new Dataset().setDatasetReference(new DatasetReference().setDatasetId(datasetId))).execute();
                if (response != null) {
                    LOG.info("Successfully created new dataset : " + response.getId());
                    return;
                }
                lastException = new IOException("Expected valid response from insert dataset job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for dataset (%s)", 4, datasetId), lastException);
    }

    public void deleteTable(String projectId, String datasetId, String tableName) {
        try {
            this.bqClient.tables().delete(projectId, datasetId, tableName).execute();
            LOG.info("Successfully deleted table: " + tableName);
        }
        catch (Exception e) {
            LOG.debug("Exception caught when deleting table: " + e.getMessage());
        }
    }

    public void deleteDataset(String projectId, String datasetId) {
        try {
            TableList tables = (TableList)this.bqClient.tables().list(projectId, datasetId).execute();
            for (TableList.Tables table : tables.getTables()) {
                this.deleteTable(projectId, datasetId, table.getTableReference().getTableId());
            }
        }
        catch (Exception e) {
            LOG.debug("Exceptions caught when listing all tables: " + e.getMessage());
        }
        try {
            this.bqClient.datasets().delete(projectId, datasetId).execute();
            LOG.info("Successfully deleted dataset: " + datasetId);
        }
        catch (Exception e) {
            LOG.debug("Exceptions caught when deleting dataset: " + e.getMessage());
        }
    }

    public void createNewTable(String projectId, String datasetId, Table newTable) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying create table ({}) after exception", (Object)newTable.getId(), (Object)lastException);
            }
            try {
                Table response = (Table)this.bqClient.tables().insert(projectId, datasetId, newTable).execute();
                if (response != null) {
                    LOG.info("Successfully created new table: " + response.getId());
                    return;
                }
                lastException = new IOException("Expected valid response from create table job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for table (%s)", 4, newTable.getId()), lastException);
    }

    public void insertDataToTable(String projectId, String datasetId, String tableName, List<Map<String, Object>> rows) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying insert table ({}) after exception", (Object)tableName, lastException);
            }
            try {
                List dataRows = rows.stream().map(row -> new TableDataInsertAllRequest.Rows().setJson(row)).collect(Collectors.toList());
                TableDataInsertAllResponse response = (TableDataInsertAllResponse)this.bqClient.tabledata().insertAll(projectId, datasetId, tableName, new TableDataInsertAllRequest().setRows(dataRows)).execute();
                if (response != null && (response.getInsertErrors() == null || response.getInsertErrors().isEmpty())) {
                    LOG.info("Successfully inserted data into table : " + tableName);
                    return;
                }
                if (response == null || response.getInsertErrors() == null) {
                    lastException = new IOException("Expected valid response from insert data job, but received null.");
                    continue;
                }
                lastException = new IOException(String.format("Got insertion error (%s)", response.getInsertErrors().toString()));
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for table (%s)", 4, tableName), lastException);
    }

    public Table getTableResource(String projectId, String datasetId, String tableId) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying tables.get ({}) after exception", (Object)tableId, lastException);
            }
            try {
                Table response = (Table)this.bqClient.tables().get(projectId, datasetId, tableId).execute();
                if (response != null) {
                    return response;
                }
                lastException = new IOException("Expected valid response from tables.get, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for tables.get (%s)", 4, tableId), lastException);
    }
}

