/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class PrepareWrite<InputT, DestinationT, OutputT>
extends PTransform<PCollection<InputT>, PCollection<KV<DestinationT, OutputT>>> {
    private DynamicDestinations<InputT, DestinationT> dynamicDestinations;
    private SerializableFunction<InputT, OutputT> formatFunction;

    public PrepareWrite(DynamicDestinations<InputT, DestinationT> dynamicDestinations, SerializableFunction<InputT, OutputT> formatFunction) {
        this.dynamicDestinations = dynamicDestinations;
        this.formatFunction = formatFunction;
    }

    public PCollection<KV<DestinationT, OutputT>> expand(PCollection<InputT> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<InputT, KV<DestinationT, OutputT>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context, @DoFn.Element InputT element, @DoFn.Timestamp Instant timestamp, BoundedWindow window, PaneInfo pane) throws IOException {
                PrepareWrite.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
                ValueInSingleWindow windowedElement = ValueInSingleWindow.of(element, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)pane);
                Object tableDestination = PrepareWrite.this.dynamicDestinations.getDestination(windowedElement);
                Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getDestination() may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.dynamicDestinations, element);
                Object outputValue = PrepareWrite.this.formatFunction.apply(element);
                Preconditions.checkArgument((outputValue != null ? 1 : 0) != 0, (String)"formatFunction may not return null, but %s returned null on element %s", (Object)PrepareWrite.this.formatFunction, element);
                context.output((Object)KV.of(tableDestination, (Object)outputValue));
            }
        }).withSideInputs(this.dynamicDestinations.getSideInputs()));
    }
}

